/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.query.oracle;

import cn.smallbun.screw.core.exception.QueryException;
import cn.smallbun.screw.core.mapping.Mapping;
import cn.smallbun.screw.core.metadata.Column;
import cn.smallbun.screw.core.metadata.Database;
import cn.smallbun.screw.core.metadata.PrimaryKey;
import cn.smallbun.screw.core.query.AbstractDatabaseQuery;
import cn.smallbun.screw.core.query.oracle.model.OracleColumnModel;
import cn.smallbun.screw.core.query.oracle.model.OracleDatabaseModel;
import cn.smallbun.screw.core.query.oracle.model.OraclePrimaryKeyModel;
import cn.smallbun.screw.core.query.oracle.model.OracleTableModel;
import cn.smallbun.screw.core.util.Assert;
import cn.smallbun.screw.core.util.CollectionUtils;
import cn.smallbun.screw.core.util.ExceptionUtils;
import cn.smallbun.screw.core.util.JdbcUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public class OracleDataBaseQuery
extends AbstractDatabaseQuery {
    private final Map<String, List<Column>> columnsCaching = new ConcurrentHashMap();

    public OracleDataBaseQuery(DataSource dataSource) {
        super(dataSource);
    }

    public Database getDataBase() throws QueryException {
        OracleDatabaseModel model = new OracleDatabaseModel();
        model.setDatabase(this.getSchema());
        return model;
    }

    public List<OracleTableModel> getTables() throws QueryException {
        List list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getTables(this.getCatalog(), this.getSchema(), "%", new String[]{"TABLE"});
            List list2 = Mapping.convertList((ResultSet)resultSet, OracleTableModel.class);
            String sql = "SELECT TABLE_NAME,COMMENTS AS REMARKS FROM USER_TAB_COMMENTS WHERE TABLE_TYPE = 'TABLE'";
            resultSet = this.prepareStatement(String.format(sql, this.getSchema())).executeQuery();
            List inquires = Mapping.convertList((ResultSet)resultSet, OracleTableModel.class);
            list2.forEach(model -> inquires.stream().filter(inquire -> model.getTableName().equals(inquire.getTableName())).forEachOrdered(inquire -> model.setRemarks(inquire.getRemarks())));
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe((Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet, (Connection)this.connection);
                throw throwable;
            }
        }
        JdbcUtils.close((ResultSet)resultSet, (Connection)this.connection);
        return list;
    }

    public List<OracleColumnModel> getTableColumns(String table) throws QueryException {
        List list;
        Assert.notEmpty((String)table, (String)"Table name can not be empty!", (Object[])new Object[0]);
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getColumns(this.getCatalog(), this.getSchema(), table, "%");
            List list2 = Mapping.convertList((ResultSet)resultSet, OracleColumnModel.class);
            List<String> tableNames = list2.stream().map(OracleColumnModel::getTableName).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty((Map)this.columnsCaching)) {
                String sql;
                if (table.equals("%")) {
                    sql = "SELECT TABLE_NAME, COLUMN_NAME, COMMENTS AS REMARKS FROM USER_COL_COMMENTS";
                    PreparedStatement statement = this.prepareStatement(sql);
                    resultSet = statement.executeQuery();
                    int fetchSize = 4284;
                    if (resultSet.getFetchSize() < fetchSize) {
                        resultSet.setFetchSize(fetchSize);
                    }
                } else {
                    sql = "SELECT TABLE_NAME, COLUMN_NAME, COMMENTS AS REMARKS FROM USER_COL_COMMENTS WHERE TABLE_NAME = '%s'";
                    resultSet = this.prepareStatement(String.format(sql, table)).executeQuery();
                }
                List inquires = Mapping.convertList((ResultSet)resultSet, OracleColumnModel.class);
                tableNames.forEach(name -> this.columnsCaching.put(name, inquires.stream().filter(i -> i.getTableName().equals(name)).collect(Collectors.toList())));
            }
            for (OracleColumnModel i : list2) {
                List columns = (List)this.columnsCaching.get(i.getTableName());
                columns.forEach(j -> {
                    if (i.getColumnName().equals(j.getColumnName()) && i.getTableName().equals(j.getTableName())) {
                        i.setRemarks(j.getRemarks());
                    }
                });
            }
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe((Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet, (Connection)this.connection);
                throw throwable;
            }
        }
        JdbcUtils.close((ResultSet)resultSet, (Connection)this.connection);
        return list;
    }

    public List<? extends Column> getTableColumns() throws QueryException {
        return this.getTableColumns("%");
    }

    public List<? extends PrimaryKey> getPrimaryKeys(String table) throws QueryException {
        List list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getPrimaryKeys(this.getCatalog(), this.getSchema(), table);
            list = Mapping.convertList((ResultSet)resultSet, OraclePrimaryKeyModel.class);
        }
        catch (SQLException e) {
            try {
                throw ExceptionUtils.mpe((Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet, (Connection)this.connection);
                throw throwable;
            }
        }
        JdbcUtils.close((ResultSet)resultSet, (Connection)this.connection);
        return list;
    }

    public List<? extends PrimaryKey> getPrimaryKeys() throws QueryException {
        List list;
        ResultSet resultSet = null;
        try {
            String sql = "SELECT NULL AS TABLE_CAT, C.OWNER AS TABLE_SCHEM, C.TABLE_NAME, C.COLUMN_NAME, C.POSITION AS KEY_SEQ, C.CONSTRAINT_NAME AS PK_NAME FROM ALL_CONS_COLUMNS C, ALL_CONSTRAINTS K WHERE K.CONSTRAINT_TYPE = 'P' AND K.OWNER LIKE '%s' ESCAPE '/' AND K.CONSTRAINT_NAME = C.CONSTRAINT_NAME AND K.TABLE_NAME = C.TABLE_NAME AND K.OWNER = C.OWNER ORDER BY COLUMN_NAME ";
            resultSet = this.prepareStatement(String.format(sql, this.getDataBase().getDatabase())).executeQuery();
            list = Mapping.convertList((ResultSet)resultSet, OraclePrimaryKeyModel.class);
        }
        catch (SQLException e) {
            try {
                throw new QueryException((Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.close((ResultSet)resultSet);
        return list;
    }

    private boolean isDda() {
        boolean bl;
        ResultSet resultSet = null;
        try {
            resultSet = this.prepareStatement("SELECT USERENV('isdba') as IS_DBA FROM DUAL").executeQuery();
            String dbaColumn = "IS_DBA";
            resultSet.next();
            bl = resultSet.getBoolean(dbaColumn);
        }
        catch (SQLException e) {
            try {
                throw new QueryException((Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                throw throwable;
            }
        }
        JdbcUtils.close((ResultSet)resultSet);
        return bl;
    }
}

