/*
 * Decompiled with CFR 0.152.
 */
package com.fanruan.api.cal;

import com.fanruan.api.err.KitError;
import com.fanruan.api.util.GeneralKit;
import com.fr.base.BaseFormula;
import com.fr.base.ScriptFormula;
import com.fr.log.FineLoggerFactory;
import com.fr.script.Calculator;
import com.fr.stable.FormulaProvider;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.Expression;
import com.fr.third.antlr.ANTLRException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormulaKit {
    @Nullable
    public static Object eval(String formula) throws KitError {
        return FormulaKit.eval((CalculatorProvider)Calculator.createCalculator(), formula);
    }

    @Nullable
    public static Object eval(CalculatorProvider calculator, String formula) throws KitError {
        try {
            return BaseFormula.createFormulaBuilder().build(formula).eval(calculator);
        }
        catch (UtilEvalError u) {
            throw new KitError(u);
        }
    }

    @NotNull
    public static BaseFormula newFormula(Object content) {
        return BaseFormula.createFormulaBuilder().build(content);
    }

    @NotNull
    public static BaseFormula newScriptFormula(Object content) {
        return new ScriptFormula(GeneralKit.objectToString(content));
    }

    public static boolean checkFormulaContent(String content) {
        String formulaText = content.trim();
        if (StringUtils.isNotEmpty((String)formulaText)) {
            BaseFormula formula = FormulaKit.newFormula(formulaText);
            Expression expression = null;
            try {
                expression = formula.parse((CalculatorProvider)Calculator.createCalculator());
            }
            catch (ANTLRException e) {
                FineLoggerFactory.getLogger().error(e.getMessage(), (Throwable)e);
            }
            return null != expression;
        }
        return true;
    }

    public static boolean checkFormulaContent(FormulaProvider formula) {
        if (formula == null) {
            return true;
        }
        return FormulaKit.checkFormulaContent(formula.getPureContent());
    }

    public static boolean canBeFormula(Object object) {
        return StableUtils.canBeFormula((Object)object);
    }
}

