/*
 * Decompiled with CFR 0.152.
 */
package com.fanruan.api.design.ui.component;

import com.fanruan.api.util.AssistKit;
import com.fr.design.gui.itextfield.UITextField;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class UIComboBox<T>
extends com.fr.design.gui.icombobox.UIComboBox {
    public UIComboBox() {
    }

    public UIComboBox(ComboBoxModel<T> model) {
        super(model);
    }

    public UIComboBox(T[] items) {
        super((Object[])items);
    }

    public UIComboBox(Vector<T> items) {
        super(items);
    }

    public void refreshSelectableItems(List<T> list) {
        Object el = this.getSelectedItem();
        this.removeAllItems();
        for (T t : list) {
            this.addItem(t);
        }
        this.getModel().setSelectedItem(el);
    }

    public static class UIComboBoxEditor
    extends BasicComboBoxEditor {
        protected UITextField textField = new UITextField();
        private Object oldValue;

        public UIComboBoxEditor() {
            this.textField.setRectDirection(4);
        }

        @Override
        public Component getEditorComponent() {
            return this.textField;
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject != null) {
                this.textField.setText(anObject.toString());
                this.oldValue = anObject;
            } else {
                this.textField.setText("");
            }
        }

        @Override
        public Object getItem() {
            Object newValue = this.textField.getText();
            if (this.oldValue != null && !(this.oldValue instanceof String)) {
                if (AssistKit.equals(newValue, this.oldValue.toString())) {
                    return this.oldValue;
                }
                Class<?> cls = this.oldValue.getClass();
                try {
                    Method method = cls.getMethod("valueOf", String.class);
                    newValue = method.invoke(this.oldValue, this.textField.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return newValue;
        }

        @Override
        public void selectAll() {
            this.textField.selectAll();
            this.textField.requestFocus();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.textField.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.textField.removeActionListener(l);
        }
    }
}

