/*
 * Decompiled with CFR 0.152.
 */
package com.fanruan.api.design.ui.component;

import com.fanruan.api.design.DesignKit;
import com.fanruan.api.design.ui.component.UIComboBox;
import com.fanruan.api.log.LogKit;
import java.awt.Dimension;
import java.util.concurrent.ExecutionException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class UILazyComboBox<T>
extends UIComboBox<T>
implements PopupMenuListener {
    private static final int NUM = 80;
    private static final String[] PENDING_CONTENT = new String[]{"", DesignKit.i18nText("Fine-Design_Basic_Loading") + "..."};
    protected boolean loaded = false;
    private Object initialSelected = null;

    protected UILazyComboBox() {
        this.setEditor(new FilterComboBoxEditor());
        this.addPopupMenuListener(this);
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public abstract Object[] load();

    public void setSelectedItem(Object anObject) {
        this.initialSelected = anObject;
        if (this.loaded) {
            super.setSelectedItem(anObject);
        } else {
            this.setModel(new DefaultComboBoxModel<Object>(new Object[]{anObject}));
            super.setSelectedItem(anObject);
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        if (this.loaded) {
            return;
        }
        DefaultComboBoxModel<String> loadingModel = new DefaultComboBoxModel<String>(PENDING_CONTENT);
        this.setModel(loadingModel);
        new SwingWorker<Object[], Void>(){

            @Override
            protected Object[] doInBackground() {
                return UILazyComboBox.this.load();
            }

            @Override
            public void done() {
                try {
                    UILazyComboBox.this.loadList((Object[])this.get());
                }
                catch (InterruptedException | ExecutionException exception) {
                    LogKit.debug(exception.getMessage());
                }
                UILazyComboBox.this.showPopup();
            }
        }.execute();
    }

    public void loadList() {
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(this.load());
        model.setSelectedItem(this.initialSelected);
        this.setModel(model);
        this.selectedItemReminder = this.initialSelected;
        this.loaded = true;
    }

    private void loadList(Object[] contents) {
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(contents);
        model.setSelectedItem(this.initialSelected);
        this.setModel(model);
        this.selectedItemReminder = this.initialSelected;
        this.loaded = true;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.width = 80;
        return dim;
    }

    class FilterComboBoxEditor
    extends UIComboBox.UIComboBoxEditor
    implements DocumentListener {
        private Object item;
        private volatile boolean filtering = false;
        private volatile boolean setting = false;

        public FilterComboBoxEditor() {
            this.textField.getDocument().addDocumentListener(this);
        }

        @Override
        public void setItem(Object item) {
            if (this.filtering) {
                return;
            }
            this.item = item;
            this.setting = true;
            this.textField.setSetting(true);
            String newText = item == null ? "" : item.toString();
            this.textField.setText(newText);
            this.textField.setSetting(false);
            this.setting = false;
        }

        @Override
        public Object getItem() {
            return this.item;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.handleChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.handleChange();
        }

        void handleChange() {
            if (this.setting) {
                return;
            }
            this.filtering = true;
            String xx = this.textField.getText();
            UILazyComboBox.this.setSelectedItem(xx);
            this.item = this.textField.getText();
            UILazyComboBox.this.setPopupVisible(true);
            this.filtering = false;
        }
    }
}

