/*
 * Decompiled with CFR 0.152.
 */
package com.fanruan.api.design.ui.component.chart;

import com.fr.data.util.function.AverageFunction;
import com.fr.data.util.function.CountFunction;
import com.fr.data.util.function.DataFunction;
import com.fr.data.util.function.MaxFunction;
import com.fr.data.util.function.MinFunction;
import com.fr.data.util.function.NoneFunction;
import com.fr.data.util.function.SumFunction;
import com.fr.general.ComparatorUtils;

public enum DataFunctionType {
    NONE_FUNCTION("Fine-Design_Chart_Data_Function_None", NoneFunction.class),
    SUM_FUNCTION("Fine-Design_Chart_Data_Function_Sum", SumFunction.class),
    AVERAGE_FUNCTION("Fine-Design_Chart_Data_Function_Average", AverageFunction.class),
    MAX_FUNCTION("Fine-Design_Chart_Data_Function_Max", MaxFunction.class),
    MIN_FUNCTION("Fine-Design_Chart_Data_Function_Min", MinFunction.class),
    COUNT_FUNCTION("Fine-Design_Chart_Data_Function_Count", CountFunction.class);

    String functionLocaleName;
    Class functionClass;
    public static final int NONE_FUNCTION_INDEX = 0;

    private DataFunctionType(String functionLocaleName, Class functionClass) {
        this.functionLocaleName = functionLocaleName;
        this.functionClass = functionClass;
    }

    public static int getIndexByFunction(DataFunction function) {
        if (function == null) {
            return 0;
        }
        for (DataFunctionType dataFunctionType : DataFunctionType.values()) {
            if (!ComparatorUtils.equals((Object)dataFunctionType.functionClass, function.getClass())) continue;
            return dataFunctionType.ordinal();
        }
        return 0;
    }

    public static DataFunction getFunctionByIndex(int index) throws IllegalAccessException, InstantiationException {
        DataFunctionType[] values = DataFunctionType.values();
        if (index < values.length) {
            return (DataFunction)values[index].functionClass.newInstance();
        }
        return null;
    }

    public static String[] getFunctionLocaleNames() {
        DataFunctionType[] values = DataFunctionType.values();
        String[] functionLocaleNames = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            functionLocaleNames[i] = values[i].functionLocaleName;
        }
        return functionLocaleNames;
    }
}

