/*
 * Decompiled with CFR 0.152.
 */
package com.fanruan.api.design.ui.component.table.model;

import com.fanruan.api.cal.ParameterKit;
import com.fanruan.api.design.DesignKit;
import com.fanruan.api.design.ui.component.UILabel;
import com.fanruan.api.design.ui.component.UITextField;
import com.fanruan.api.design.ui.component.table.action.UITableEditAction;
import com.fanruan.api.design.ui.component.table.model.UITableModelAdapter;
import com.fanruan.api.design.ui.editor.ValueEditorPane;
import com.fanruan.api.design.ui.editor.ValueEditors;
import com.fanruan.api.log.LogKit;
import com.fanruan.api.util.IOKit;
import com.fanruan.api.util.StringKit;
import com.fr.design.mainframe.DesignerContext;
import com.fr.stable.ParameterProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collections;
import javax.swing.AbstractCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class ParameterTableModel
extends UITableModelAdapter<ParameterProvider> {
    public static final int NO_CHART_USE = 0;
    public static final int CHART_NORMAL_USE = 1;
    public static final int FORM_NORMAL_USE = -1;
    private static final long serialVersionUID = 1L;
    protected Component component = null;

    public ParameterTableModel() {
        this(0);
    }

    public ParameterTableModel(int paraUseType) {
        super(new String[]{DesignKit.i18nText("Fine-Design_Basic_Parameter"), DesignKit.i18nText("Fine-Design_Basic_Value")});
        this.setColumnClass(new Class[]{ParameterEditor.class, ParameterValueEditor.class});
        this.setDefaultEditor(ParameterValueEditor.class, new ParameterValueEditor(paraUseType));
        this.setDefaultEditor(ParameterEditor.class, new ParameterEditor());
        this.setDefaultRenderer(ParameterValueEditor.class, new ParameterValueRenderer(paraUseType));
    }

    public ParameterTableModel(int paraUseType, Component component) {
        super(new String[]{DesignKit.i18nText("Fine-Design_Basic_Parameter"), DesignKit.i18nText("Fine-Design_Basic_Value")});
        this.setColumnClass(new Class[]{ParameterEditor.class, ParameterValueEditor.class});
        this.setDefaultEditor(ParameterValueEditor.class, new ParameterValueEditor(paraUseType));
        this.setDefaultEditor(ParameterEditor.class, new ParameterEditor());
        this.setDefaultRenderer(ParameterValueEditor.class, new ParameterValueRenderer(paraUseType));
        this.component = component;
    }

    public ParameterTableModel(ValueEditorPane valueEditorPane, ValueEditorPane valueRenderPane, Component component) {
        super(new String[]{DesignKit.i18nText("Fine-Design_Basic_Parameter"), DesignKit.i18nText("Fine-Design_Basic_Value")});
        this.setColumnClass(new Class[]{ParameterEditor.class, ParameterValueEditor.class});
        this.setDefaultEditor(ParameterValueEditor.class, new ParameterValueEditor(valueEditorPane));
        this.setDefaultEditor(ParameterEditor.class, new ParameterEditor());
        this.setDefaultRenderer(ParameterValueEditor.class, new ParameterValueRenderer(valueRenderPane));
        this.component = component;
    }

    public boolean isCellEditable(int row, int col) {
        if (col == 1) {
            return this.getList().get(row) != null && StringKit.isNotEmpty(((ParameterProvider)this.getList().get(row)).getName());
        }
        return true;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        ParameterProvider para = (ParameterProvider)this.getList().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return para.getName();
            }
            case 1: {
                return para.getValue();
            }
        }
        return null;
    }

    @Override
    public UITableEditAction[] createAction() {
        return new UITableEditAction[]{new AddParameterAction(), new DeleteAction(), new MoveUpAction(), new MoveDownAction()};
    }

    private void addParameter() {
        ParameterProvider para = ParameterKit.newParameter();
        this.addRow(para);
        this.fireTableDataChanged();
        this.table.getSelectionModel().setSelectionInterval(this.table.getRowCount() - 1, this.table.getRowCount() - 1);
    }

    private class ParameterValueRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private ValueEditorPane editor;
        private UILabel disableLabel = new UILabel(DesignKit.i18nText("Fine-Design_Basic_Set_Paramete_Name"));

        public ParameterValueRenderer(int paraUseType) {
            this(ValueEditors.createValueEditorPaneWithUseType(paraUseType));
        }

        public ParameterValueRenderer(ValueEditorPane valueEditorPane) {
            this.disableLabel.setForeground(Color.pink);
            this.disableLabel.setHorizontalAlignment(0);
            this.editor = valueEditorPane;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table.isCellEditable(row, column)) {
                if (value == null) {
                    this.editor.populate("");
                } else {
                    this.editor.populate(value);
                }
                return this.editor;
            }
            return this.disableLabel;
        }
    }

    private class ParameterValueEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        private ValueEditorPane editor;

        public ParameterValueEditor(int paraUseType) {
            this(ValueEditors.createValueEditorPaneWithUseType(paraUseType));
        }

        public ParameterValueEditor(ValueEditorPane valueEditorPane) {
            this.editor = valueEditorPane;
            this.addCellEditorListener(new CellEditorListener(){

                @Override
                public void editingCanceled(ChangeEvent e) {
                }

                @Override
                public void editingStopped(ChangeEvent e) {
                    if (ParameterTableModel.this.table.getSelectedRow() == -1) {
                        return;
                    }
                    ParameterProvider para = (ParameterProvider)ParameterTableModel.this.getList().get(ParameterTableModel.this.table.getSelectedRow());
                    para.setValue(ParameterValueEditor.this.getCellEditorValue());
                    ParameterTableModel.this.fireTableDataChanged();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editor.populate(value == null ? "" : value);
            return this.editor;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor.update();
        }
    }

    public class ParameterEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private UITextField textField = new UITextField();

        public ParameterEditor() {
            this.addCellEditorListener(new CellEditorListener(){

                @Override
                public void editingCanceled(ChangeEvent e) {
                }

                @Override
                public void editingStopped(ChangeEvent e) {
                    if (ParameterTableModel.this.table.getSelectedRow() == -1) {
                        return;
                    }
                    ParameterProvider para = (ParameterProvider)ParameterTableModel.this.getList().get(ParameterTableModel.this.table.getSelectedRow());
                    String value = StringKit.trimToNull(ParameterEditor.this.textField.getText());
                    para.setName(value);
                    ParameterTableModel.this.fireTableDataChanged();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.textField.setText((String)value);
            return this.textField;
        }

        @Override
        public Object getCellEditorValue() {
            return this.textField.getText();
        }
    }

    protected class MoveDownAction
    extends UITableEditAction {
        public MoveDownAction() {
            this.setName(DesignKit.i18nText("Fine-Design_Basic_Utils_Move_Down"));
            this.setSmallIcon(IOKit.readIcon("/com/fr/design/images/control/down.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = ParameterTableModel.this.table.getSelectedRow();
            ParameterTableModel.this.stopCellEditing();
            if (ParameterTableModel.this.getList().size() < 2 || selectedRow == ParameterTableModel.this.getRowCount() - 1) {
                return;
            }
            Collections.swap(ParameterTableModel.this.getList(), selectedRow, selectedRow + 1);
            ParameterTableModel.this.fireTableDataChanged();
            ParameterTableModel.this.table.getSelectionModel().setSelectionInterval(selectedRow + 1, selectedRow + 1);
        }

        @Override
        public void checkEnabled() {
        }
    }

    protected class MoveUpAction
    extends UITableEditAction {
        public MoveUpAction() {
            this.setName(DesignKit.i18nText("Fine-Design_Basic_Utils_Move_Up"));
            this.setSmallIcon(IOKit.readIcon("/com/fr/design/images/control/up.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = ParameterTableModel.this.table.getSelectedRow();
            ParameterTableModel.this.stopCellEditing();
            if (ParameterTableModel.this.getList().size() < 2 || selectedRow == 0) {
                return;
            }
            Collections.swap(ParameterTableModel.this.getList(), selectedRow, selectedRow - 1);
            ParameterTableModel.this.fireTableDataChanged();
            ParameterTableModel.this.table.getSelectionModel().setSelectionInterval(selectedRow - 1, selectedRow - 1);
        }

        @Override
        public void checkEnabled() {
        }
    }

    protected class DeleteAction
    extends UITableEditAction {
        private Component component = null;

        public DeleteAction() {
            this.setName(DesignKit.i18nText("Fine-Design_Report_Delete"));
            this.setSmallIcon(IOKit.readIcon("/com/fr/base/images/cell/control/remove.png"));
        }

        public DeleteAction(Component component) {
            this.setName(DesignKit.i18nText("Fine-Design_Report_Delete"));
            this.setSmallIcon(IOKit.readIcon("/com/fr/base/images/cell/control/remove.png"));
            this.component = component;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int val;
            int[] selectedRow = ParameterTableModel.this.table.getSelectedRows();
            if (this.isMultiSelected()) {
                JOptionPane.showMessageDialog((Component)DesignerContext.getDesignerFrame(), DesignKit.i18nText("Fine-Design_Basic_Multiple_Select_Warn_Text"));
                return;
            }
            if (ParameterTableModel.this.table.getCellEditor() != null) {
                try {
                    ParameterTableModel.this.table.getCellEditor().stopCellEditing();
                }
                catch (Exception ee) {
                    LogKit.error(ee.getMessage(), ee);
                }
            }
            if (ParameterTableModel.this.getRowCount() < 1) {
                return;
            }
            if (this.component == null) {
                this.component = DesignerContext.getDesignerFrame();
            }
            if ((val = JOptionPane.showConfirmDialog(this.component, DesignKit.i18nText("Fine-Design_Basic_Utils_Are_You_Sure_To_Remove_The_Selected_Item") + "?", DesignKit.i18nText("Fine-Design_Basic_Remove"), 2, 3)) != 0) {
                return;
            }
            for (int i = 0; i < selectedRow.length; ++i) {
                if (selectedRow[i] - i < 0) continue;
                ParameterTableModel.this.removeRow(selectedRow[i] - i);
            }
            ParameterTableModel.this.fireTableDataChanged();
            int selection = selectedRow[0] > ParameterTableModel.this.table.getRowCount() ? ParameterTableModel.this.table.getRowCount() - 1 : (selectedRow[0] > 1 ? selectedRow[0] - 1 : 0);
            ParameterTableModel.this.table.getSelectionModel().setSelectionInterval(selection, selection);
        }

        private boolean isMultiSelected() {
            int[] selectedRow = ParameterTableModel.this.table.getSelectedRows();
            return selectedRow.length == 1 && (selectedRow[0] > ParameterTableModel.this.table.getRowCount() - 1 || selectedRow[0] < 0) || selectedRow.length == 0;
        }

        @Override
        public void checkEnabled() {
            this.setEnabled(!this.isMultiSelected());
        }
    }

    protected class AddParameterAction
    extends UITableModelAdapter.AddTableRowAction {
        public AddParameterAction() {
            super(ParameterTableModel.this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            ParameterTableModel.this.addParameter();
        }
    }
}

