/*
 * Decompiled with CFR 0.152.
 */
package com.fanruan.api.design.ui.editor;

import com.fanruan.api.design.DesignKit;
import com.fanruan.api.design.ui.editor.ValueEditorPane;
import com.fanruan.api.util.StringKit;
import com.fr.base.BaseFormula;
import com.fr.design.editor.editor.BooleanEditor;
import com.fr.design.editor.editor.ColumnRowEditor;
import com.fr.design.editor.editor.ColumnRowGroupEditor;
import com.fr.design.editor.editor.ColumnSelectedEditor;
import com.fr.design.editor.editor.ConstantsEditor;
import com.fr.design.editor.editor.CursorEditor;
import com.fr.design.editor.editor.DateEditor;
import com.fr.design.editor.editor.DoubleEditor;
import com.fr.design.editor.editor.Editor;
import com.fr.design.editor.editor.FormulaEditor;
import com.fr.design.editor.editor.IntegerEditor;
import com.fr.design.editor.editor.NoneEditor;
import com.fr.design.editor.editor.ParameterEditor;
import com.fr.design.editor.editor.SpinnerIntegerEditor;
import com.fr.design.editor.editor.TextEditor;
import com.fr.design.editor.editor.WidgetNameEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ValueEditors {
    public static ValueEditorPane createValueEditorPane(Editor<?>[] editors) {
        return ValueEditors.createValueEditorPane(editors, "", "");
    }

    public static ValueEditorPane createValueEditorPane(Editor<?>[] editors, String popupName, String textEditorValue) {
        return new ValueEditorPane(editors, popupName, textEditorValue);
    }

    public static ValueEditorPane createValueEditorPane(Editor<?>[] editors, String popupName, String textEditorValue, int editor_center_width) {
        return new ValueEditorPane(editors, popupName, textEditorValue, editor_center_width);
    }

    public static ValueEditorPane createBasicValueEditorPane() {
        return ValueEditors.createValueEditorPane(ValueEditors.basicEditors(), "", "");
    }

    public static ValueEditorPane createFormulaValueEditorPane() {
        return ValueEditors.createValueEditorPane(new Editor[]{new FormulaEditor(DesignKit.i18nText("Fine-Design_Basic_Parameter_Formula"))}, "", "");
    }

    public static ValueEditorPane createBasicValueEditorPane(int editorCenterWidth) {
        return ValueEditors.createValueEditorPane(ValueEditors.basicEditors(), "", "", editorCenterWidth);
    }

    public static ValueEditorPane createFormEditorPane() {
        return ValueEditors.createValueEditorPane(ValueEditors.formEditors(), "", "");
    }

    public static ValueEditorPane createURLValueEditorPane(String popupName, String textEditorValue) {
        return ValueEditors.createValueEditorPane(ValueEditors.URLEditors(popupName, textEditorValue), "", "");
    }

    public static ValueEditorPane createDateValueEditorPane(String popupName, String textEditorValue) {
        return ValueEditors.createValueEditorPane(ValueEditors.dateEditors(popupName, textEditorValue), "", "");
    }

    public static ValueEditorPane createAllValueEditorPane() {
        return ValueEditors.createValueEditorPane(ValueEditors.allEditors(), "", "");
    }

    public static ValueEditorPane createBasicEditorWithoutFormulaPane() {
        return ValueEditors.createValueEditorPane(ValueEditors.basicEditorsWithoutFormula(), "", "");
    }

    public static ValueEditorPane createDateValueEditorPane() {
        return ValueEditors.createValueEditorPane(ValueEditors.dateEditors(), "", "");
    }

    public static ValueEditorPane createValueEditorPaneWithUseType(int paraUseType) {
        return ValueEditors.createValueEditorPaneWithUseType(paraUseType, null);
    }

    public static ValueEditorPane createValueEditorPaneWithUseType(int paraUseType, Map<String, BaseFormula> hyperLinkEditorMap) {
        if (paraUseType == 0) {
            return ValueEditors.createBasicValueEditorPane();
        }
        if (paraUseType == -1) {
            return ValueEditors.createFormEditorPane();
        }
        return ValueEditors.createChartHotValueEditorPane(hyperLinkEditorMap);
    }

    public static ValueEditorPane createChartHotValueEditorPane(Map<String, BaseFormula> hyperLinkEditorMap) {
        return ValueEditors.createValueEditorPane(ValueEditors.chartHotEditors(hyperLinkEditorMap), "", "");
    }

    public static Editor<?>[] basicEditors() {
        FormulaEditor formulaEditor = new FormulaEditor(DesignKit.i18nText("Fine-Design_Basic_Parameter_Formula"));
        return new Editor[]{new TextEditor(), new SpinnerIntegerEditor(), new DoubleEditor(), new DateEditor(true, DesignKit.i18nText("Fine-Design_Basic_Date")), new BooleanEditor(), formulaEditor};
    }

    public static Editor<?>[] formEditors() {
        FormulaEditor formulaEditor = new FormulaEditor(DesignKit.i18nText("Fine-Design_Basic_Parameter_Formula"));
        return new Editor[]{new TextEditor(), new IntegerEditor(), new DoubleEditor(), new DateEditor(true, DesignKit.i18nText("Fine-Design_Basic_Date")), new BooleanEditor(), formulaEditor, new WidgetNameEditor(DesignKit.i18nText("Fine-Design_Report_Widget"))};
    }

    public static Editor<?>[] extendedEditors() {
        FormulaEditor formulaEditor = new FormulaEditor(DesignKit.i18nText("Fine-Design_Basic_Parameter_Formula"));
        return new Editor[]{new TextEditor(), new IntegerEditor(), new DoubleEditor(), new DateEditor(true, DesignKit.i18nText("Fine-Design_Basic_Date")), new BooleanEditor(), formulaEditor, new ParameterEditor(), new ColumnRowEditor(DesignKit.i18nText("Fine-Design_Basic_Cell"))};
    }

    public static Editor<?>[] extendedCellGroupEditors() {
        FormulaEditor formulaEditor = new FormulaEditor(DesignKit.i18nText("Fine-Design_Basic_Parameter_Formula"));
        return new Editor[]{new TextEditor(), new IntegerEditor(), new DoubleEditor(), new DateEditor(true, DesignKit.i18nText("Fine-Design_Basic_Date")), new BooleanEditor(), formulaEditor, new ParameterEditor(), new ColumnRowEditor(DesignKit.i18nText("Fine-Design_Basic_Cell")), new ColumnRowGroupEditor(DesignKit.i18nText("Fine-Design_Basic_Cell_Group"))};
    }

    public static Editor<?>[] cellGroupEditor() {
        return new Editor[]{new ColumnRowEditor(DesignKit.i18nText("Fine-Design_Basic_Cell")), new ColumnRowGroupEditor(DesignKit.i18nText("Fine-Design_Basic_Cell_Group"))};
    }

    public static Editor<?>[] URLEditors(String popupName, String textEditorValue) {
        return new Editor[]{new NoneEditor(textEditorValue, StringKit.isEmpty(popupName) ? DesignKit.i18nText("Fine-Design_Basic_None") : popupName), new TextEditor()};
    }

    public static Editor<?>[] dateEditors(String popupName, String textEditorValue) {
        return new Editor[]{new NoneEditor(textEditorValue, StringKit.isEmpty(popupName) ? DesignKit.i18nText("Fine-Design_Basic_None") : popupName), new DateEditor(true, DesignKit.i18nText("Fine-Design_Basic_Date")), new FormulaEditor(DesignKit.i18nText("Fine-Design_Basic_Parameter_Formula"))};
    }

    public static Editor<?>[] allEditors() {
        FormulaEditor formulaEditor = new FormulaEditor(DesignKit.i18nText("Fine-Design_Basic_Parameter_Formula"));
        return new Editor[]{new TextEditor(), new IntegerEditor(), new DoubleEditor(), new DateEditor(true, DesignKit.i18nText("Fine-Design_Basic_Date")), new BooleanEditor(), formulaEditor, new ParameterEditor(), new ColumnRowEditor(DesignKit.i18nText("Fine-Design_Basic_Cell")), new ColumnSelectedEditor()};
    }

    public static Editor<?>[] basicEditorsWithoutFormula() {
        return new Editor[]{new TextEditor(), new IntegerEditor(), new DoubleEditor(), new DateEditor(true, DesignKit.i18nText("Fine-Design_Basic_Date")), new BooleanEditor()};
    }

    public static Editor<?>[] noCRnoColumnEditors() {
        FormulaEditor formulaEditor = new FormulaEditor(DesignKit.i18nText("Fine-Design_Basic_Parameter_Formula"));
        return new Editor[]{new TextEditor(), new IntegerEditor(), new DoubleEditor(), new DateEditor(true, DesignKit.i18nText("Fine-Design_Basic_Date")), new BooleanEditor(), formulaEditor, new ParameterEditor()};
    }

    public static Editor<?>[] numberEditors() {
        FormulaEditor formulaEditor = new FormulaEditor(DesignKit.i18nText("Fine-Design_Basic_Parameter_Formula"));
        return new Editor[]{new IntegerEditor(), new DoubleEditor(), formulaEditor, new ParameterEditor()};
    }

    public static Editor<?>[] dateEditors() {
        FormulaEditor formulaEditor = new FormulaEditor(DesignKit.i18nText("Fine-Design_Basic_Parameter_Formula"));
        return new Editor[]{new DateEditor(true, DesignKit.i18nText("Fine-Design_Basic_Date")), formulaEditor, new ParameterEditor()};
    }

    public static Editor<?>[] StoreProcedureEditors() {
        FormulaEditor formulaEditor = new FormulaEditor(DesignKit.i18nText("Fine-Design_Basic_Parameter_Formula"));
        formulaEditor.setEnabled(true);
        return new Editor[]{new CursorEditor(), new TextEditor(), new IntegerEditor(), new DoubleEditor(), new DateEditor(true, DesignKit.i18nText("Fine-Design_Basic_Date")), new BooleanEditor(), formulaEditor};
    }

    public static Editor[] chartHotEditors(Map<String, BaseFormula> hyperLinkEditorMap) {
        List<Editor> list = ValueEditors.createEditors4Chart(hyperLinkEditorMap);
        list.add((Editor)new TextEditor());
        list.add((Editor)new IntegerEditor());
        list.add((Editor)new DoubleEditor());
        list.add((Editor)new DateEditor(true, DesignKit.i18nText("Fine-Design_Basic_Date")));
        list.add((Editor)new BooleanEditor());
        FormulaEditor formulaEditor = new FormulaEditor(DesignKit.i18nText("Fine-Design_Basic_Parameter_Formula"));
        formulaEditor.setEnabled(true);
        list.add((Editor)formulaEditor);
        return list.toArray(new Editor[0]);
    }

    private static List<Editor> createEditors4Chart(Map<String, BaseFormula> hyperLinkEditorMap) {
        ArrayList<Editor> lists = new ArrayList<Editor>();
        if (hyperLinkEditorMap == null) {
            return lists;
        }
        for (Map.Entry<String, BaseFormula> entry : hyperLinkEditorMap.entrySet()) {
            ConstantsEditor editor = new ConstantsEditor(entry.getKey(), entry.getValue());
            editor.setEnabled(false);
            lists.add((Editor)editor);
        }
        return lists;
    }
}

