/*
 * Decompiled with CFR 0.152.
 */
package com.fanruan.api.design.work;

import com.fanruan.api.conf.ConfigurationKit;
import com.fanruan.api.data.ConnectionKit;
import com.fanruan.api.data.open.BaseConnection;
import com.fanruan.api.design.DesignKit;
import com.fanruan.api.design.macro.DataSourceConstants;
import com.fanruan.api.generic.Runner;
import com.fanruan.api.util.AssistKit;
import com.fanruan.api.util.StringKit;
import com.fr.data.impl.Connection;
import com.fr.design.DesignerEnvManager;
import com.fr.design.data.datapane.connect.ConnectionListPane;
import com.fr.design.data.datapane.connect.ConnectionShowPane;
import com.fr.design.data.datapane.connect.ItemEditableComboBoxPanel;
import com.fr.design.dialog.BasicDialog;
import com.fr.design.dialog.DialogActionAdapter;
import com.fr.design.dialog.DialogActionListener;
import com.fr.file.ConnectionConfig;
import com.fr.stable.NameReference;
import com.fr.transaction.WorkerCallBack;
import com.fr.workspace.WorkContext;
import com.fr.workspace.server.connection.DBConnectAuth;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class ConnectionComboBoxPanel
extends ItemEditableComboBoxPanel {
    private static final long serialVersionUID = 1L;
    private Class<? extends Connection> cls;
    private List<String> nameList = new ArrayList<String>();

    public ConnectionComboBoxPanel(Class<? extends Connection> cls) {
        this.cls = cls;
        this.itemComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String selected = ConnectionComboBoxPanel.this.getSelectedItem();
                if (StringKit.isNotBlank(selected)) {
                    DesignerEnvManager.getEnvManager().setRecentSelectedConnection(selected);
                }
            }
        });
        this.refreshItems();
    }

    protected Iterator<String> items() {
        this.nameList = new ArrayList<String>();
        Iterator<String> nameIt = ConnectionKit.getConnections().keySet().iterator();
        Collection noAuthConnections = ((DBConnectAuth)WorkContext.getCurrent().get(DBConnectAuth.class)).getNoAuthConnections();
        if (noAuthConnections == null) {
            return this.nameList.iterator();
        }
        while (nameIt.hasNext()) {
            String conName = nameIt.next();
            if (noAuthConnections.contains(conName)) continue;
            Connection connection = ConnectionKit.getConnection(conName);
            this.filterConnection(connection, conName, this.nameList);
        }
        return this.nameList.iterator();
    }

    protected void filterConnection(@Nullable Connection connection, String conName, List<String> nameList) {
        if (connection != null) {
            connection.addConnection(nameList, conName, new Class[]{BaseConnection.class});
        }
    }

    public int getConnectionSize() {
        return this.nameList.size();
    }

    private boolean isEmptyConnection() {
        return this.nameList.isEmpty();
    }

    public String getConnection(int i) {
        return this.nameList.get(i);
    }

    protected void editItems() {
        final ConnectionListPane connectionListPane = new ConnectionListPane();
        final ConnectionConfig connectionConfig = ConnectionConfig.getInstance();
        ConnectionConfig cloned = (ConnectionConfig)connectionConfig.mirror();
        connectionListPane.populate(cloned);
        final BasicDialog connectionListDialog = connectionListPane.showLargeWindow(SwingUtilities.getWindowAncestor((Component)((Object)this)), null);
        connectionListDialog.addDialogActionListener((DialogActionListener)new DialogActionAdapter(){

            public void doOk() {
                if (!connectionListPane.isNamePermitted()) {
                    connectionListDialog.setDoOKSucceed(false);
                    return;
                }
                ConfigurationKit.modify(ConnectionConfig.class, new Runner(){

                    @Override
                    public void run() {
                        connectionListPane.update(connectionConfig);
                    }
                }, new WorkerCallBack(){

                    public boolean beforeCommit() {
                        return ConnectionComboBoxPanel.this.doWithDatasourceManager(connectionConfig, (ConnectionShowPane)connectionListPane, connectionListDialog);
                    }

                    public void afterCommit() {
                        DesignKit.getDesignerBean("databasename").refreshBeanElement();
                    }

                    public void afterRollback() {
                    }
                });
            }
        });
        connectionListDialog.setVisible(true);
        this.refreshItems();
    }

    public void populate(Connection connection) {
        this.editButton.setEnabled(WorkContext.getCurrent().isRoot());
        if (connection instanceof NameReference) {
            this.setSelectedItem(((NameReference)connection).getName());
        } else {
            String s = DesignerEnvManager.getEnvManager().getRecentSelectedConnection();
            if (StringKit.isNotBlank(s)) {
                for (int i = 0; i < this.getConnectionSize(); ++i) {
                    String t = this.getConnection(i);
                    if (!AssistKit.equals(s, t)) continue;
                    this.setSelectedItem(s);
                    break;
                }
            }
            if (StringKit.isBlank(this.getSelectedItem()) && !this.isEmptyConnection()) {
                this.setSelectedItem(this.getConnection(0));
            }
        }
    }

    private boolean doWithDatasourceManager(ConnectionConfig datasourceManager, ConnectionShowPane connectionShowPane, BasicDialog databaseListDialog) {
        boolean isFailed = false;
        int index = this.isConnectionMapContainsRename(datasourceManager);
        if (index != -1) {
            isFailed = true;
            connectionShowPane.setSelectedIndex(index);
        }
        databaseListDialog.setDoOKSucceed(!isFailed);
        return !isFailed;
    }

    private int isConnectionMapContainsRename(ConnectionConfig datasourceManager) {
        Map tableDataMap = datasourceManager.getConnections();
        if (tableDataMap.containsKey(DataSourceConstants.ILLEGAL_NAME_HOLDER)) {
            return datasourceManager.getConnectionIndex(DataSourceConstants.ILLEGAL_NAME_HOLDER);
        }
        return -1;
    }
}

