/*
 * Decompiled with CFR 0.152.
 */
package com.fanruan.api.design.work;

import com.fanruan.api.design.ui.component.UIButton;
import com.fanruan.api.design.ui.component.UIComboBox;
import com.fanruan.api.design.ui.component.UILabel;
import com.fanruan.api.log.LogKit;
import com.fanruan.api.macro.EncodeConstants;
import com.fanruan.api.util.ArrayKit;
import com.fanruan.api.util.StringKit;
import com.fr.data.impl.Connection;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.data.impl.JNDIDatabaseConnection;
import com.fr.data.operator.DataOperator;
import com.fr.design.beans.BasicBeanPane;
import com.fr.design.data.datapane.connect.JDBCDefPane;
import com.fr.design.data.datapane.connect.JNDIDefPane;
import com.fr.design.i18n.Toolkit;
import com.fr.design.layout.FRGUIPaneFactory;
import com.fr.design.scrollruler.ModLineBorder;
import com.fr.design.utils.gui.GUICoreUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.Border;

public abstract class DatabaseConnectionPane<E extends Connection>
extends BasicBeanPane<Connection> {
    private UILabel message;
    private UIButton okButton;
    private UIButton cancelButton;
    private JDialog dialog;
    private UILabel uiLabel;
    private UIComboBox<String> charSetComboBox;
    private String originalCharSet = null;
    ActionListener testConnectionActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            final SwingWorker connectionThread = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    try {
                        Connection database = DatabaseConnectionPane.this.updateBean();
                        boolean connect = DataOperator.getInstance().testConnection(database);
                        DatabaseConnectionPane.this.okButton.setEnabled(true);
                        DatabaseConnectionPane.this.message.setText(database.connectMessage(connect));
                        if (connect) {
                            DatabaseConnectionPane.this.uiLabel.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
                            DatabaseConnectionPane.this.message.setText(Toolkit.i18nText((String)"Fine-Design_Basic_Datasource_Connection_Successfully"));
                        } else {
                            DatabaseConnectionPane.this.uiLabel.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
                            DatabaseConnectionPane.this.message.setText(Toolkit.i18nText((String)"Fine-Design_Basic_Connection_Failed"));
                        }
                    }
                    catch (Exception exp) {
                        LogKit.error(exp.getMessage(), exp);
                    }
                    return null;
                }
            };
            connectionThread.execute();
            DatabaseConnectionPane.this.initDialogPane();
            DatabaseConnectionPane.this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatabaseConnectionPane.this.dialog.dispose();
                }
            });
            DatabaseConnectionPane.this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatabaseConnectionPane.this.dialog.dispose();
                    connectionThread.cancel(true);
                }
            });
            DatabaseConnectionPane.this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    connectionThread.cancel(true);
                }
            });
            DatabaseConnectionPane.this.dialog.show();
            DatabaseConnectionPane.this.dialog.dispose();
        }
    };

    public DatabaseConnectionPane() {
        this.initComponents();
    }

    protected void initComponents() {
        this.message = new UILabel();
        this.uiLabel = new UILabel();
        this.okButton = new UIButton(Toolkit.i18nText((String)"Fine-Design_Report_OK"));
        this.cancelButton = new UIButton(Toolkit.i18nText((String)"Fine-Design_Basic_Cancel"));
        String[] defaultEncode = new String[]{Toolkit.i18nText((String)"Fine-Design_Encode_Auto")};
        this.charSetComboBox = new UIComboBox<String>(ArrayKit.addAll(defaultEncode, EncodeConstants.ENCODING_ARRAY));
        this.setLayout(new BorderLayout());
        JPanel northPane = FRGUIPaneFactory.createY_AXISBoxInnerContainer_L_Pane();
        this.add(northPane, "North");
        JPanel testPane = FRGUIPaneFactory.createNormalFlowInnerContainer_M_Pane();
        northPane.add((Component)testPane, "North");
        UIButton testButton = new UIButton(Toolkit.i18nText((String)"Fine-Design_Basic_Datasource_Test_Connection"));
        testPane.add((Component)((Object)testButton));
        testButton.addActionListener(this.testConnectionActionListener);
        testPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 4));
        northPane.add((Component)this.mainPanel(), "Center");
        JPanel chartSetPane = FRGUIPaneFactory.createNColumnGridInnerContainer_S_Pane((int)2);
        northPane.add(chartSetPane);
        chartSetPane.setBorder(BorderFactory.createTitledBorder((Border)new ModLineBorder(1), Toolkit.i18nText((String)"Fine-Design_Basic_Advanced")));
        chartSetPane.add(GUICoreUtils.createNamedPane(this.charSetComboBox, (String)(Toolkit.i18nText((String)"Fine-Design_Basic_Datasource_Charset") + ":")));
    }

    protected abstract JPanel mainPanel();

    public void populateBean(Connection ob) {
        this.originalCharSet = ob.getOriginalCharsetName();
        if (StringKit.isBlank(this.originalCharSet)) {
            this.charSetComboBox.setSelectedItem(Toolkit.i18nText((String)"Fine-Design_Encode_Auto"));
        } else {
            this.charSetComboBox.setSelectedItem(ob.getOriginalCharsetName());
        }
        this.populateSubDatabaseConnectionBean(ob);
    }

    protected abstract void populateSubDatabaseConnectionBean(E var1);

    public Connection updateBean() {
        E ob = this.updateSubDatabaseConnectionBean();
        ob.setOriginalCharsetName(this.originalCharSet);
        if (this.charSetComboBox.getSelectedIndex() == 0) {
            ob.setNewCharsetName(null);
            ob.setOriginalCharsetName(null);
        } else {
            ob.setNewCharsetName("GBK");
            ob.setOriginalCharsetName((String)this.charSetComboBox.getSelectedItem());
        }
        return ob;
    }

    protected abstract E updateSubDatabaseConnectionBean();

    private void initDialogPane() {
        this.message.setText(Toolkit.i18nText((String)"Fine-Design_Basic_Datasource_Test_Connection") + "...");
        this.message.setBorder(BorderFactory.createEmptyBorder(8, 5, 0, 0));
        this.okButton.setEnabled(false);
        this.dialog = new JDialog((Dialog)SwingUtilities.getWindowAncestor((Component)((Object)this)), Toolkit.i18nText((String)"Fine-Design_Basic_Datasource_Test_Connection"), true);
        this.dialog.setSize(new Dimension(268, 118));
        this.okButton.setEnabled(false);
        JPanel jp = new JPanel();
        JPanel upPane = new JPanel();
        JPanel downPane = new JPanel();
        this.uiLabel = new UILabel(UIManager.getIcon("OptionPane.informationIcon"));
        upPane.setLayout(new FlowLayout(0, 10, 10));
        upPane.add((Component)((Object)this.uiLabel));
        upPane.add((Component)((Object)this.message));
        downPane.setLayout(new FlowLayout(1, 6, 0));
        downPane.add((Component)((Object)this.okButton));
        downPane.add((Component)((Object)this.cancelButton));
        jp.setLayout(new BoxLayout(jp, 1));
        jp.add(upPane);
        jp.add(downPane);
        this.dialog.add(jp);
        this.dialog.setResizable(false);
        this.dialog.setLocationRelativeTo(SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    public static class JNDI
    extends com.fr.design.data.datapane.connect.DatabaseConnectionPane<JNDIDatabaseConnection> {
        private static JNDIDefPane jndiDefPane = new JNDIDefPane();

        protected JPanel mainPanel() {
            return jndiDefPane;
        }

        protected boolean isFineBI() {
            return false;
        }

        protected void populateSubDatabaseConnectionBean(JNDIDatabaseConnection ob) {
            jndiDefPane.populate(ob);
        }

        protected JNDIDatabaseConnection updateSubDatabaseConnectionBean() {
            return jndiDefPane.update();
        }

        protected String title4PopupWindow() {
            return "JNDI";
        }
    }

    public static class JDBC
    extends com.fr.design.data.datapane.connect.DatabaseConnectionPane<JDBCDatabaseConnection> {
        private static JDBCDefPane jdbcDefPane = new JDBCDefPane();

        protected JPanel mainPanel() {
            return jdbcDefPane;
        }

        protected boolean isFineBI() {
            return false;
        }

        protected void populateSubDatabaseConnectionBean(JDBCDatabaseConnection ob) {
            jdbcDefPane.populate(ob);
        }

        protected JDBCDatabaseConnection updateSubDatabaseConnectionBean() {
            return jdbcDefPane.update();
        }

        protected String title4PopupWindow() {
            return "JDBC";
        }
    }
}

