/*
 * Decompiled with CFR 0.152.
 */
package com.fanruan.api.design.work;

import com.fanruan.api.design.DesignKit;
import com.fanruan.api.design.ui.component.UIButton;
import com.fanruan.api.design.ui.component.UITextArea;
import com.fanruan.api.design.ui.container.UIScrollPane;
import com.fanruan.api.design.util.GUICoreKit;
import com.fr.base.FRContext;
import com.fr.design.dialog.BasicPane;
import com.fr.design.gui.itree.filetree.ClassFileTree;
import com.fr.design.gui.itree.filetree.TemplateFileTree;
import com.fr.design.i18n.Toolkit;
import com.fr.file.filetree.FileNodeFilter;
import com.fr.file.filetree.IOFileNodeFilter;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public class ReportletPane
extends BasicPane {
    private TemplateFileTree templateReportletTree;
    private UIScrollPane templateScrollPane;
    private ClassFileTree classReportletTree;
    private UIScrollPane classScrollPane;
    private UIButton switchButton;
    private CardLayout card;
    private JPanel cardPane;

    public ReportletPane() {
        this.setLayout(new BorderLayout());
        UITextArea textPane = new UITextArea();
        this.add((Component)((Object)textPane), "North");
        textPane.setEditable(false);
        textPane.setLineWrap(true);
        textPane.setFont(FRContext.getDefaultValues().getFRFont().deriveFont(1, 12.0f));
        textPane.setText(DesignKit.i18nText("Fine-Design_Basic_Schedule_The_Selected_File_Must_Be_End_With_Filter"));
        JPanel centerPane = GUICoreKit.createBorderLayoutPane();
        this.add(centerPane, "Center");
        this.switchButton = new UIButton("switch");
        centerPane.add((Component)GUICoreKit.createBorderLayoutPane(new Object[]{this.switchButton, "West"}), "North");
        this.switchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportletPane.this.switchCardPane(ReportletPane.this.templateScrollPane.isVisible());
            }
        });
        this.cardPane = new JPanel();
        centerPane.add((Component)this.cardPane, "Center");
        this.card = new CardLayout();
        this.cardPane.setLayout(this.card);
        this.templateReportletTree = new TemplateFileTree();
        IOFileNodeFilter filter = new IOFileNodeFilter(new String[]{".cpt", ".class", ".frm", ".form"});
        this.templateReportletTree.setFileNodeFilter((FileNodeFilter)filter);
        this.templateScrollPane = new UIScrollPane((Component)this.templateReportletTree);
        this.cardPane.add((Component)((Object)this.templateScrollPane), "TEMPLATE");
        this.classReportletTree = new ClassFileTree();
        this.classScrollPane = new UIScrollPane((Component)this.classReportletTree);
        this.cardPane.add((Component)((Object)this.classScrollPane), "CLASS");
        this.refreshEnv();
    }

    private void switchCardPane(boolean switch2Class) {
        if (switch2Class) {
            this.card.show(this.cardPane, "CLASS");
            this.switchButton.setText(DesignKit.i18nText("Fine-Design_Basic_Utils_Switch_To_Template_Reportlet"));
        } else {
            this.card.show(this.cardPane, "TEMPLATE");
            this.switchButton.setText(DesignKit.i18nText("Fine-Design_Basic_Utils_Switch_To_Class_Reportlet"));
        }
    }

    public void checkValid() throws Exception {
        String path = this.getSelectedReportletPath();
        if (path == null) {
            throw new Exception(DesignKit.i18nText("Fine-Design_Basic_Function_The_Selected_File_Cannot_Be_Null"));
        }
    }

    public void refreshEnv() {
        this.templateReportletTree.refreshEnv();
        this.classReportletTree.refreshEnv();
    }

    protected String title4PopupWindow() {
        return Toolkit.i18nText((String)"Fine-Design_Basic_Reportlet");
    }

    public String getSelectedReportletPath() {
        if (this.templateScrollPane.isVisible()) {
            return this.templateReportletTree.getSelectedTemplatePath();
        }
        if (this.classScrollPane.isVisible()) {
            return this.classReportletTree.getSelectedClassPath();
        }
        return null;
    }

    public void setSelectedReportletPath(String templatePath) {
        if (templatePath == null) {
            return;
        }
        if (templatePath.endsWith(".class")) {
            this.switchCardPane(true);
            this.classReportletTree.setSelectedClassPath(templatePath);
        } else {
            this.switchCardPane(false);
            this.templateReportletTree.setSelectedTemplatePath(templatePath);
        }
    }
}

