/*
 * Decompiled with CFR 0.152.
 */
package com.fanruan.api.design.work.form.creator;

import com.fanruan.api.log.LogKit;
import com.fr.design.designer.creator.CRPropertyDescriptor;
import java.beans.IntrospectionException;

public class Attribute {
    private CRPropertyDescriptor descriptor;

    public static Attribute newAttribute(String name, Class<?> beanClass) {
        return new Attribute(name, beanClass);
    }

    public static Attribute newAttribute(String name, Class<?> beanClass, String readMethod, String writeMethod) {
        return new Attribute(name, beanClass, readMethod, writeMethod);
    }

    private Attribute(String name, Class<?> beanClass) {
        try {
            this.descriptor = new CRPropertyDescriptor(name, beanClass);
        }
        catch (IntrospectionException e) {
            LogKit.error(e.getMessage(), e);
        }
    }

    private Attribute(String name, Class<?> beanClass, String readMethod, String writeMethod) {
        try {
            this.descriptor = new CRPropertyDescriptor(name, beanClass, readMethod, writeMethod);
        }
        catch (IntrospectionException e) {
            LogKit.error(e.getMessage(), e);
        }
    }

    public Attribute keyValue(String name, Object value) {
        if (this.descriptor != null) {
            this.descriptor.putKeyValue(name, value);
        }
        return this;
    }

    public Attribute i18n(String i18nName) {
        if (this.descriptor != null) {
            this.descriptor.setI18NName(i18nName);
        }
        return this;
    }

    public Attribute editorClass(Class<?> clazz) {
        if (this.descriptor != null) {
            this.descriptor.setEditorClass(clazz);
        }
        return this;
    }

    public Attribute rendererClass(Class<?> clazz) {
        if (this.descriptor != null) {
            this.descriptor.setRendererClass(clazz);
        }
        return this;
    }

    protected CRPropertyDescriptor toPropertyDescriptor() {
        return this.descriptor;
    }
}

