/*
 * Decompiled with CFR 0.152.
 */
package com.fanruan.api.design.work.form.creator;

import com.fanruan.api.util.IOKit;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;

public class OpacityButton
extends JButton {
    private static final float FULL_OPACITY = 1.0f;
    private static final float HALF_OPACITY = 0.4f;
    private String name;
    private String imagePath;
    private float opacity;

    public OpacityButton(String name, String imagePath, float opacity) {
        this.name = name;
        this.imagePath = imagePath;
        this.opacity = opacity;
        this.draw();
    }

    private void draw() {
        ImageIcon imageIcon = (ImageIcon)IOKit.readIcon(this.imagePath);
        Image img = imageIcon.getImage();
        MediaTracker mt = new MediaTracker(this);
        int w = 21;
        int h = 21;
        mt.addImage(img, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException ignore) {
            return;
        }
        GraphicsConfiguration gc = new JFrame().getGraphicsConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h, 3);
        Graphics2D g = (Graphics2D)((Image)image).getGraphics();
        AlphaComposite alpha = AlphaComposite.getInstance(3, 1.0f);
        g.setComposite(alpha);
        g.drawImage(img, 0, 0, this);
        g.setColor(Color.black);
        g.drawString(this.name, 25, 20);
        g.dispose();
        AlphaComposite alpha2 = AlphaComposite.getInstance(3, this.opacity);
        BufferedImage image1 = gc.createCompatibleImage(w, h, 3);
        g = (Graphics2D)((Image)image1).getGraphics();
        g.setComposite(alpha2);
        g.drawImage(img, 2, 2, this);
        g.setColor(Color.black);
        g.drawString(this.name, 25, 20);
        g.dispose();
        this.setIgnoreRepaint(true);
        this.setFocusable(false);
        this.setBorder(null);
        this.setContentAreaFilled(false);
        this.setIcon(new ImageIcon(image1));
        this.setRolloverIcon(new ImageIcon(image1));
        this.setPressedIcon(new ImageIcon(image));
    }

    public void makeVisible(boolean visible) {
        this.opacity = visible ? 1.0f : 0.4f;
        this.draw();
    }
}

