/*
 * Decompiled with CFR 0.152.
 */
package com.fanruan.api.net.http;

import com.fanruan.api.log.LogKit;
import com.fanruan.api.net.http.rs.BaseHttpResponseHandle;
import com.fanruan.api.net.http.rs.HttpRequest;
import com.fanruan.api.net.http.rs.HttpRequestType;
import com.fanruan.api.net.http.rs.HttpResponseType;
import com.fanruan.api.net.http.rs.StreamResponseHandle;
import com.fanruan.api.net.http.rs.TextResponseHandle;
import com.fanruan.api.net.http.rs.UploadResponseHandle;
import com.fr.third.guava.collect.Maps;
import com.fr.third.org.apache.http.HttpEntity;
import com.fr.third.org.apache.http.HttpEntityEnclosingRequest;
import com.fr.third.org.apache.http.HttpHost;
import com.fr.third.org.apache.http.NoHttpResponseException;
import com.fr.third.org.apache.http.client.HttpRequestRetryHandler;
import com.fr.third.org.apache.http.client.config.RequestConfig;
import com.fr.third.org.apache.http.client.entity.UrlEncodedFormEntity;
import com.fr.third.org.apache.http.client.methods.CloseableHttpResponse;
import com.fr.third.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import com.fr.third.org.apache.http.client.methods.HttpRequestBase;
import com.fr.third.org.apache.http.client.methods.HttpUriRequest;
import com.fr.third.org.apache.http.client.protocol.HttpClientContext;
import com.fr.third.org.apache.http.client.utils.URIBuilder;
import com.fr.third.org.apache.http.config.Registry;
import com.fr.third.org.apache.http.config.RegistryBuilder;
import com.fr.third.org.apache.http.conn.HttpClientConnectionManager;
import com.fr.third.org.apache.http.conn.routing.HttpRoute;
import com.fr.third.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.fr.third.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.fr.third.org.apache.http.entity.FileEntity;
import com.fr.third.org.apache.http.entity.mime.HttpMultipartMode;
import com.fr.third.org.apache.http.entity.mime.MultipartEntityBuilder;
import com.fr.third.org.apache.http.impl.client.CloseableHttpClient;
import com.fr.third.org.apache.http.impl.client.HttpClients;
import com.fr.third.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.fr.third.org.apache.http.message.BasicNameValuePair;
import com.fr.third.org.apache.http.protocol.HttpContext;
import com.fr.third.org.apache.http.ssl.SSLContexts;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpKit {
    private static final int RETRY_TIMES = 5;
    private static CloseableHttpClient httpClient = null;
    private static final Object SYNC_LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpClient getHttpClient(String url) {
        String hostname = url.split("/")[2];
        int port = 80;
        if (hostname.contains(":")) {
            String[] arr = hostname.split(":");
            hostname = arr[0];
            port = Integer.parseInt(arr[1]);
        }
        if (httpClient == null) {
            Object object = SYNC_LOCK;
            synchronized (object) {
                if (httpClient == null) {
                    httpClient = HttpKit.createHttpClient(hostname, port, SSLContexts.createDefault());
                }
            }
        }
        return httpClient;
    }

    public static CloseableHttpClient createHttpClient(String hostname, int port, SSLContext sslContext) {
        return HttpKit.createHttpClient(200, 40, 100, hostname, port, sslContext);
    }

    private static CloseableHttpClient createHttpClient(int maxTotal, int maxPerRoute, int maxRoute, String hostname, int port, SSLContext sslContext) {
        PlainConnectionSocketFactory socketFactory = PlainConnectionSocketFactory.getSocketFactory();
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext);
        Registry registry = RegistryBuilder.create().register("http", (Object)socketFactory).register("https", (Object)sslConnectionSocketFactory).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
        cm.setMaxTotal(maxTotal);
        cm.setDefaultMaxPerRoute(maxPerRoute);
        HttpHost httpHost = new HttpHost(hostname, port);
        cm.setMaxPerRoute(new HttpRoute(httpHost), maxRoute);
        HttpRequestRetryHandler httpRequestRetryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount >= 5) {
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    return true;
                }
                if (exception instanceof SSLHandshakeException) {
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    return false;
                }
                if (exception instanceof UnknownHostException) {
                    return false;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                com.fr.third.org.apache.http.HttpRequest request = clientContext.getRequest();
                return !(request instanceof HttpEntityEnclosingRequest);
            }
        };
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setRetryHandler(httpRequestRetryHandler).build();
    }

    private static void setHttpEntity(@NotNull HttpEntityEnclosingRequestBase requestBase, @NotNull HttpRequest httpRequest) {
        HttpEntity httpEntity = httpRequest.getHttpEntity();
        if (httpEntity != null) {
            requestBase.setEntity(httpEntity);
            return;
        }
        Map<String, String> params = httpRequest.getParams();
        if (params == null || params.isEmpty()) {
            return;
        }
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            pairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        try {
            requestBase.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, httpRequest.getEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            LogKit.error(e.getMessage(), e);
        }
    }

    private static <V> Map<String, String> transformMap(Map<String, V> oldMap) {
        if (oldMap == null) {
            return null;
        }
        return Maps.transformEntries(oldMap, (Maps.EntryTransformer)new Maps.EntryTransformer<String, V, String>(){

            public String transformEntry(@Nullable String key, @Nullable V value) {
                return value == null ? null : value.toString();
            }
        });
    }

    public static <V> String post(String url, Map<String, V> params) throws IOException {
        return HttpKit.executeAndParse(HttpRequest.custom().url(url).post(HttpKit.transformMap(params)).build());
    }

    @Deprecated
    public static <T, V> T post(String url, Map<String, V> params, HttpResponseType<T> responseType) throws IOException {
        CloseableHttpResponse response = HttpKit.execute(HttpRequest.custom().url(url).post(HttpKit.transformMap(params)).build());
        return responseType.result(response, null);
    }

    @Deprecated
    public static <V> String post(String url, Map<String, V> params, Map<String, String> headers) throws IOException {
        return HttpKit.executeAndParse(HttpRequest.custom().url(url).post(HttpKit.transformMap(params)).headers(headers).build());
    }

    @Deprecated
    public static <T, V> T post(String url, Map<String, V> params, Map<String, String> headers, HttpResponseType<T> responseType) throws IOException {
        CloseableHttpResponse response = HttpKit.execute(HttpRequest.custom().url(url).post(HttpKit.transformMap(params)).headers(headers).build());
        return responseType.result(response, null);
    }

    @Deprecated
    public static <V> String post(String url, Map<String, V> params, String responseEncoding) throws IOException {
        return HttpKit.executeAndParse(HttpRequest.custom().url(url).post(HttpKit.transformMap(params)).build(), new TextResponseHandle(responseEncoding));
    }

    @Deprecated
    public static <V> String post(String url, Map<String, V> params, String responseEncoding, Map<String, String> headers) throws IOException {
        return HttpKit.executeAndParse(HttpRequest.custom().url(url).post(HttpKit.transformMap(params)).headers(headers).build(), new TextResponseHandle(responseEncoding));
    }

    public static <V> String post(String url, Map<String, V> params, String responseEncoding, String paramsEncoding, Map<String, String> headers) throws IOException {
        return HttpKit.executeAndParse(HttpRequest.custom().url(url).post(HttpKit.transformMap(params)).encoding(paramsEncoding).headers(headers).build(), new TextResponseHandle(responseEncoding));
    }

    public static <T, V> T post(String url, Map<String, V> params, String responseEncoding, String paramsEncoding, Map<String, String> headers, HttpResponseType<T> responseType) throws IOException {
        CloseableHttpResponse response = HttpKit.execute(HttpRequest.custom().url(url).post(HttpKit.transformMap(params)).encoding(paramsEncoding).headers(headers).build());
        return responseType.result(response, responseEncoding);
    }

    public static String get(String url) throws IOException {
        return HttpKit.executeAndParse(HttpRequest.custom().url(url).build());
    }

    public static String get(String url, Map<String, String> params) throws IOException {
        return HttpKit.executeAndParse(HttpRequest.custom().url(url).params(params).build());
    }

    public static String get(String url, Map<String, String> params, Map<String, String> headers) throws IOException {
        return HttpKit.executeAndParse(HttpRequest.custom().url(url).params(params).headers(headers).build());
    }

    public static String get(String url, Map<String, String> params, String responseEncoding) throws IOException {
        return HttpKit.executeAndParse(HttpRequest.custom().url(url).params(params).build(), new TextResponseHandle(responseEncoding));
    }

    public static String get(String url, Map<String, String> params, String responseEncoding, Map<String, String> headers) throws IOException {
        return HttpKit.executeAndParse(HttpRequest.custom().url(url).params(params).headers(headers).build(), new TextResponseHandle(responseEncoding));
    }

    public static ByteArrayInputStream download(String url) throws IOException {
        return HttpKit.executeAndParse(HttpRequest.custom().url(url).build(), StreamResponseHandle.DEFAULT);
    }

    public static ByteArrayInputStream download(String url, Map<String, String> params, String responseEncoding, Map<String, String> headers) throws IOException {
        return HttpKit.executeAndParse(HttpRequest.custom().url(url).params(params).headers(headers).build(), new StreamResponseHandle(responseEncoding));
    }

    public static void upload(String url, File file) throws IOException {
        HttpKit.upload(url, file, Charset.forName("utf-8"));
    }

    public static void upload(String url, File file, Charset charset) throws IOException {
        HttpKit.upload(url, new FileEntity(file), charset);
    }

    public static void upload(String url, MultipartEntityBuilder builder, Charset charset) throws IOException {
        HttpKit.upload(url, builder, charset, Collections.emptyMap(), HttpRequestType.POST);
    }

    public static void upload(String url, FileEntity fileEntity, Charset charset) throws IOException {
        HttpKit.upload(url, (HttpEntity)fileEntity, charset, Collections.emptyMap(), HttpRequestType.POST);
    }

    public static void upload(String url, MultipartEntityBuilder builder, Charset charset, Map<String, String> headers, HttpRequestType httpRequestType) throws IOException {
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        HttpEntity reqEntity = builder.setCharset(charset).build();
        HttpKit.upload(url, reqEntity, charset, headers, httpRequestType);
    }

    public static void upload(String url, HttpEntity reqEntity, Charset charset, Map<String, String> headers, HttpRequestType httpRequestType) throws IOException {
        HttpKit.executeAndParse(HttpRequest.custom().url(url).headers(headers).method(httpRequestType).httpEntity(reqEntity).encoding(charset.toString()).build(), UploadResponseHandle.DEFAULT);
    }

    public static String executeAndParse(HttpRequest httpRequest) throws IOException {
        return HttpKit.executeAndParse(httpRequest, TextResponseHandle.DEFAULT);
    }

    public static <T> T executeAndParse(HttpRequest httpRequest, BaseHttpResponseHandle<T> handle) throws IOException {
        return handle.parse(HttpKit.execute(httpRequest));
    }

    public static CloseableHttpResponse execute(HttpRequest httpRequest) throws IOException {
        return HttpKit.execute(HttpKit.getHttpClient(httpRequest.getUrl()), httpRequest);
    }

    public static CloseableHttpResponse execute(CloseableHttpClient httpClient, HttpRequest httpRequest) throws IOException {
        RequestConfig requestConfig;
        String url = httpRequest.getUrl();
        HttpRequestBase httpRequestBase = httpRequest.getMethod().createHttpRequest(url);
        httpRequestBase.setHeader("User-Agent", "Mozilla/5.0");
        Map<String, String> headers = httpRequest.getHeaders();
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpRequestBase.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if ((requestConfig = httpRequest.getConfig()) != null) {
            httpRequestBase.setConfig(requestConfig);
        }
        if (HttpEntityEnclosingRequestBase.class.isAssignableFrom(httpRequestBase.getClass())) {
            HttpKit.setHttpEntity((HttpEntityEnclosingRequestBase)httpRequestBase, httpRequest);
        } else {
            Map<String, String> params = httpRequest.getParams();
            if (params != null && !params.isEmpty()) {
                httpRequestBase.setURI(URI.create(HttpKit.buildUrl(url, params, httpRequest.getEncoding())));
            }
        }
        return httpClient.execute((HttpUriRequest)httpRequestBase);
    }

    public static String buildUrl(String url, Map<String, String> params) {
        try {
            return HttpKit.buildUrl(url, params, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return url;
        }
    }

    private static String buildUrl(String url, Map<String, String> params, String paramsEncoding) throws UnsupportedEncodingException {
        if (params == null || params.isEmpty()) {
            return url;
        }
        try {
            URIBuilder builder = new URIBuilder(url);
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String key = URLEncoder.encode(entry.getKey(), paramsEncoding);
                String value = URLEncoder.encode(entry.getValue(), paramsEncoding);
                builder.setParameter(key, value);
            }
            return builder.build().toString();
        }
        catch (URISyntaxException e) {
            LogKit.debug("Error to build url, please check the arguments.");
            return url;
        }
    }
}

