/*
 * Decompiled with CFR 0.152.
 */
package com.fanruan.api.net.http.rs;

import com.fanruan.api.net.http.rs.HttpRequestType;
import com.fr.third.org.apache.http.HttpEntity;
import com.fr.third.org.apache.http.client.config.RequestConfig;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequest {
    private static final int TIME_OUT = 10000;
    private static final RequestConfig DEFAULT = RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(10000).setSocketTimeout(10000).build();
    private String url;
    private Map<String, String> headers;
    private Map<String, String> params;
    @Nullable
    private RequestConfig config;
    @Nullable
    private HttpEntity httpEntity;
    private HttpRequestType method;
    private String encoding;

    private HttpRequest(Builder builder) {
        this.url = builder.url;
        this.headers = builder.headers;
        this.params = builder.params;
        this.config = builder.config;
        this.encoding = builder.encoding;
        this.httpEntity = builder.httpEntity;
        this.method = builder.method;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public RequestConfig getConfig() {
        return this.config;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public HttpEntity getHttpEntity() {
        return this.httpEntity;
    }

    public HttpRequestType getMethod() {
        return this.method;
    }

    public static Builder custom() {
        return new Builder();
    }

    static /* synthetic */ RequestConfig access$800() {
        return DEFAULT;
    }

    public static final class Builder {
        private String url;
        private Map<String, String> headers = Collections.emptyMap();
        private Map<String, String> params = Collections.emptyMap();
        @Nullable
        private RequestConfig config = HttpRequest.access$800();
        @Nullable
        private HttpEntity httpEntity;
        private String encoding = "UTF-8";
        private HttpRequestType method = HttpRequestType.GET;

        private Builder() {
        }

        public HttpRequest build() {
            if (this.url == null) {
                throw new IllegalStateException("url == null");
            }
            return new HttpRequest(this);
        }

        public Builder url(@NotNull String url) {
            if (url == null) {
                throw new NullPointerException("url == null");
            }
            this.url = url;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            if (headers != null) {
                this.headers = headers;
            }
            return this;
        }

        public Builder params(Map<String, String> params) {
            if (params != null) {
                this.params = params;
            }
            return this;
        }

        public Builder config(RequestConfig config) {
            this.config = config;
            return this;
        }

        public Builder get() {
            this.method = HttpRequestType.GET;
            return this;
        }

        public Builder post(HttpEntity httpEntity) {
            this.method = HttpRequestType.POST;
            this.httpEntity(httpEntity);
            return this;
        }

        public Builder post(Map<String, String> params) {
            this.method = HttpRequestType.POST;
            this.params(params);
            return this;
        }

        public Builder put(HttpEntity httpEntity) {
            this.method = HttpRequestType.PUT;
            this.httpEntity(httpEntity);
            return this;
        }

        public Builder put(Map<String, String> params) {
            this.method = HttpRequestType.PUT;
            this.params(params);
            return this;
        }

        public Builder delete() {
            this.method = HttpRequestType.DELETE;
            return this;
        }

        public Builder encoding(String encoding) {
            if (encoding == null) {
                throw new NullPointerException("httpEntity == null");
            }
            this.encoding = encoding;
            return this;
        }

        public Builder httpEntity(HttpEntity httpEntity) {
            this.httpEntity = httpEntity;
            return this;
        }

        public Builder method(@NotNull HttpRequestType method) {
            if (method == null) {
                throw new NullPointerException("method == null");
            }
            this.method = method;
            return this;
        }
    }
}

