/*
 * Decompiled with CFR 0.152.
 */
package com.fanruan.api.net.http.rs;

import com.fr.third.org.apache.http.HttpEntity;
import com.fr.third.org.apache.http.client.methods.CloseableHttpResponse;
import com.fr.third.org.apache.http.client.methods.HttpUriRequest;
import com.fr.third.org.apache.http.client.protocol.HttpClientContext;
import com.fr.third.org.apache.http.impl.client.CloseableHttpClient;
import com.fr.third.org.apache.http.protocol.HttpContext;
import com.fr.third.org.apache.http.util.EntityUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public interface HttpResponseType<T> {
    public static final HttpResponseType<String> TEXT = new HttpResponseType<String>(){

        @Override
        public String result(CloseableHttpClient client, String url, HttpUriRequest request, String charset) throws IOException {
            CloseableHttpResponse response = client.execute(request, (HttpContext)HttpClientContext.create());
            return this.result(response, charset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String result(CloseableHttpResponse response, String charset) throws IOException {
            try {
                HttpEntity entity = response.getEntity();
                String result = EntityUtils.toString((HttpEntity)entity, (String)charset);
                EntityUtils.consume((HttpEntity)entity);
                String string = result;
                return string;
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
    };
    public static final HttpResponseType<ByteArrayInputStream> STREAM = new HttpResponseType<ByteArrayInputStream>(){

        @Override
        public ByteArrayInputStream result(CloseableHttpClient client, String url, HttpUriRequest request, String charset) throws IOException {
            CloseableHttpResponse response = client.execute(request, (HttpContext)HttpClientContext.create());
            return this.result(response, charset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteArrayInputStream result(CloseableHttpResponse response, String charset) throws IOException {
            InputStream in = null;
            try {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    int bytesRead;
                    in = entity.getContent();
                    byte[] buff = new byte[8000];
                    ByteArrayOutputStream bao = new ByteArrayOutputStream();
                    while ((bytesRead = in.read(buff)) != -1) {
                        bao.write(buff, 0, bytesRead);
                    }
                    byte[] data = bao.toByteArray();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
                    return byteArrayInputStream;
                }
                ByteArrayInputStream byteArrayInputStream = null;
                return byteArrayInputStream;
            }
            finally {
                if (response != null) {
                    response.close();
                }
                if (in != null) {
                    in.close();
                }
            }
        }
    };

    @Deprecated
    public T result(CloseableHttpClient var1, String var2, HttpUriRequest var3, String var4) throws IOException;

    public T result(CloseableHttpResponse var1, String var2) throws IOException;
}

