/*
 * Decompiled with CFR 0.152.
 */
package com.fanruan.api.report;

import com.fanruan.api.log.LogKit;
import com.fr.base.Margin;
import com.fr.main.FineBook;
import com.fr.page.ClippedPageProvider;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportPageProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.stable.ReportSettings;
import com.fr.stable.unit.UNIT;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PrintKit {
    private PrintKit() {
    }

    public static List<PaperSettingProvider> getPaperSettings(FineBook book) {
        return PrintKit.getPaperSettings(book, null);
    }

    @Nullable
    public static List<PaperSettingProvider> getPaperSettings(FineBook book, Margin offsetMargin) {
        if (book == null) {
            return null;
        }
        ArrayList<PaperSettingProvider> list = new ArrayList<PaperSettingProvider>();
        for (int i = 0; i < book.getReportCount(); ++i) {
            ReportSettingsProvider reportSettings = book.getReport(i).getReportSettings();
            if (reportSettings == null) {
                reportSettings = ReportSettings.DEFAULTSETTINGS;
            }
            try {
                PaperSettingProvider setting = (PaperSettingProvider)reportSettings.getPaperSetting().clone();
                Margin margin = setting.getMargin();
                if (offsetMargin != null) {
                    margin.setTop((UNIT)margin.getTop().add(offsetMargin.getTop()));
                    margin.setLeft((UNIT)margin.getLeft().add(offsetMargin.getLeft()));
                    margin.setBottom((UNIT)margin.getBottom().subtract(offsetMargin.getBottom()));
                    margin.setRight((UNIT)margin.getRight().subtract(offsetMargin.getRight()));
                }
                list.add(setting);
                continue;
            }
            catch (CloneNotSupportedException e) {
                LogKit.error(e.getMessage(), e);
                break;
            }
        }
        return list;
    }

    @Nullable
    public static ClippedPageProvider pick(ReportPageProvider reportPage) {
        if (reportPage == null) {
            return null;
        }
        ClippedPageProvider[] clippers = reportPage.getPages();
        if (clippers.length == 1 && clippers[0] != null) {
            ClippedPageProvider cp = clippers[0];
            cp.deriveResolution(96);
            return cp;
        }
        return null;
    }

    public static boolean isCellPrintable(CellElement cell) {
        if (cell == null) {
            return false;
        }
        CellGUIAttr gui = cell.getCellGUIAttr();
        return gui == null || gui.isPrintContent();
    }
}

