/*
 * Decompiled with CFR 0.152.
 */
package com.fanruan.api.report.analy;

import com.fanruan.api.report.analy.data.TreeNode;
import com.fr.cache.list.IntList;
import com.fr.form.ui.Widget;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.report.cell.ResultCellElement;
import com.fr.report.cell.WidgetAttrElem;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.report.Report;
import com.fr.report.report.ResultReport;
import com.fr.report.web.button.form.TreeNodeToggleButton;
import com.fr.report.worksheet.AnalysisRWorkSheet;
import com.fr.script.Calculator;
import com.fr.stable.web.Repository;
import com.fr.web.core.TreeHTMLWriter;
import com.fr.web.core.reportcase.WebElementReportCase;
import com.fr.web.core.reportcase.WebReportCase;
import com.fr.web.output.html.chwriter.CellHtmlWriter;
import com.fr.web.output.html.chwriter.ViewCellWriter;
import com.fr.web.request.EmptyRepository;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AnalyKit {
    public static Map<Integer, TreeNode> generateResultBookTree(ResultWorkBook book, int index) {
        ResultReport resultWS = book.getResultReport(index);
        if (!(resultWS instanceof AnalysisRWorkSheet)) {
            throw new UnsupportedOperationException();
        }
        AnalysisRWorkSheet analysisRWorkSheet = (AnalysisRWorkSheet)resultWS;
        Calculator c = Calculator.createCalculator();
        c.setAttribute(Report.KEY, (Object)analysisRWorkSheet);
        TreeHTMLWriter htmlWriter = new TreeHTMLWriter();
        ViewCellWriter cellHtmlWriter = new ViewCellWriter((Repository)new EmptyRepository(), 1, resultWS.getReportSettings(), true);
        htmlWriter.writeReportToHtml((WebReportCase)new WebElementReportCase((ElementCase)analysisRWorkSheet, (Repository)new EmptyRepository()), 1, (CellHtmlWriter)cellHtmlWriter, (Repository)new EmptyRepository(), "");
        cellHtmlWriter.dealWithAllTreeNodeRelation(c);
        return AnalyKit.generateNodeTree(analysisRWorkSheet);
    }

    private static Map<Integer, TreeNode> generateNodeTree(AnalysisRWorkSheet resultWS) {
        int rowSize = resultWS.getRowCount();
        HashMap<Integer, TreeNode> nodeMap = new HashMap<Integer, TreeNode>();
        for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
            Widget widget;
            IntList sonList;
            ResultCellElement treeNodeCell = AnalyKit.findToggleCell(resultWS, rowIndex);
            if (treeNodeCell == null || (sonList = ((TreeNodeToggleButton)(widget = ((WidgetAttrElem)treeNodeCell).getWidget())).getRelativeIndexList()) == null || sonList.size() <= 1 || sonList.get(0) != -1 || nodeMap.containsKey(treeNodeCell.getRow())) continue;
            AnalyKit.buildNodeMap(resultWS, treeNodeCell, nodeMap, -1);
        }
        return nodeMap;
    }

    private static ResultCellElement findToggleCell(AnalysisRWorkSheet reportCase, int rowIndex) {
        Iterator cellIterator = reportCase.getRow(rowIndex);
        while (cellIterator.hasNext()) {
            ResultCellElement tmpCell = (ResultCellElement)cellIterator.next();
            if (!(tmpCell instanceof WidgetAttrElem) || !(((WidgetAttrElem)tmpCell).getWidget() instanceof TreeNodeToggleButton)) continue;
            return tmpCell;
        }
        return null;
    }

    private static void buildNodeMap(AnalysisRWorkSheet reportCase, ResultCellElement cellElment, Map<Integer, TreeNode> nodeMap, int parent) {
        if (cellElment == null) {
            return;
        }
        TreeNodeToggleButton toggleButton = (TreeNodeToggleButton)((WidgetAttrElem)cellElment).getWidget();
        int self = cellElment.getRow();
        IntList sonList = toggleButton.getRelativeIndexList();
        if (sonList != null && sonList.size() > 1 && sonList.get(0) == -1) {
            nodeMap.put(self, new TreeNode(self, parent, sonList));
            int size = sonList.size();
            for (int i = 0; i < size; ++i) {
                AnalyKit.buildNodeMap(reportCase, AnalyKit.findToggleCell(reportCase, sonList.get(i)), nodeMap, self);
            }
        }
    }
}

