/*
 * Decompiled with CFR 0.152.
 */
package com.fanruan.api.security;

import com.fanruan.api.log.LogKit;
import com.fr.cert.token.JwtBuilder;
import com.fr.cert.token.Jwts;
import com.fr.cert.token.SignatureAlgorithm;
import com.fr.cert.token.SignatureException;
import com.fr.cert.token.impl.DefaultClaims;
import com.fr.security.KeySecretSeedConfig;
import com.fr.security.SecurityToolbox;
import java.io.IOException;
import java.security.Key;
import java.util.Date;
import java.util.Map;

public class JwtKit {
    private static final String JWT_ID = "jwt";
    private static final String ISSUER = "fanruan";
    private static final SignatureAlgorithm DEFAULT_ALGORITHM = SignatureAlgorithm.HS256;

    public static String createJWT(String issuer, String subject, String audience, Date expiration, Date notBeforeTime, Date issuerAtTime, String jwtId, SignatureAlgorithm algorithm, Key secretKey) {
        JwtBuilder builder = Jwts.builder().setIssuer(issuer).setSubject(subject).setAudience(audience).setExpiration(expiration).setNotBefore(notBeforeTime).setIssuedAt(issuerAtTime).setId(jwtId).signWith(algorithm, secretKey);
        return builder.compact();
    }

    public static String createDefaultJWT(String subject) {
        JwtBuilder builder = Jwts.builder().setIssuer(ISSUER).setIssuedAt(new Date()).setSubject(subject).setId(JWT_ID).signWith(DEFAULT_ALGORITHM, JwtKit.getKeyBytes());
        return builder.compact();
    }

    public static String createDefaultJWT(String subject, String description) {
        JwtBuilder builder = ((JwtBuilder)Jwts.builder().setIssuer(ISSUER).setIssuedAt(new Date()).setSubject(subject).setDescription(description)).setId(JWT_ID).signWith(DEFAULT_ALGORITHM, JwtKit.getKeyBytes());
        return builder.compact();
    }

    public static String createDefaultJWT(String subject, String description, long timeout) {
        Date currentTime = new Date();
        Date timeoutTime = new Date(currentTime.getTime() + timeout);
        JwtBuilder builder = ((JwtBuilder)Jwts.builder().setIssuer(ISSUER).setIssuedAt(currentTime).setExpiration(timeoutTime).setSubject(subject).setDescription(description)).setId(JWT_ID).signWith(DEFAULT_ALGORITHM, JwtKit.getKeyBytes());
        return builder.compact();
    }

    public static String createDefaultJWT(String subject, long timeout) {
        Date currentTime = new Date();
        Date timeoutTime = new Date(currentTime.getTime() + timeout);
        JwtBuilder builder = Jwts.builder().setIssuer(ISSUER).setIssuedAt(currentTime).setExpiration(timeoutTime).setSubject(subject).setId(JWT_ID).signWith(DEFAULT_ALGORITHM, JwtKit.getKeyBytes());
        return builder.compact();
    }

    public static Map<String, Object> parseJWT(String jwt) {
        try {
            return (Map)Jwts.parser().setSigningKey(JwtKit.getKeyBytes()).parseClaimsJws(jwt).getBody();
        }
        catch (SignatureException e) {
            LogKit.warn(e.getMessage());
            return new DefaultClaims();
        }
    }

    public static String createVariedJWT(String signatureKey, Map<String, Object> claims) {
        JwtBuilder builder = Jwts.builder().setIssuer(ISSUER).setIssuedAt(new Date()).setClaims(claims).setId(JWT_ID).signWith(DEFAULT_ALGORITHM, signatureKey);
        return builder.compact();
    }

    public static String createVariedJWT(String signatureKey, long timeout, Map<String, Object> claims) {
        Date currentTime = new Date();
        Date timeoutTime = new Date(currentTime.getTime() + timeout);
        JwtBuilder builder = Jwts.builder().setIssuer(ISSUER).setIssuedAt(new Date()).setExpiration(timeoutTime).setClaims(claims).setId(JWT_ID).signWith(DEFAULT_ALGORITHM, signatureKey);
        return builder.compact();
    }

    public static Map<String, Object> parseJWT(String jwt, String signatureKey) {
        try {
            return (Map)Jwts.parser().setSigningKey(signatureKey).parseClaimsJws(jwt).getBody();
        }
        catch (SignatureException e) {
            LogKit.warn(e.getMessage());
            return new DefaultClaims();
        }
    }

    private static byte[] getKeyBytes() {
        try {
            return SecurityToolbox.base642Byte((String)KeySecretSeedConfig.getInstance().getTrustSeed());
        }
        catch (IOException e) {
            LogKit.error("key secret seed base64 decode error");
            return new byte[0];
        }
    }
}

