/*
 * Decompiled with CFR 0.152.
 */
package com.fanruan.api.util.trans;

import com.fanruan.api.util.trans.BaseSmsBody;
import com.fr.base.sms.SMSManager;
import com.fr.json.JSONArray;
import java.util.List;

public class BatchSmsBody
extends BaseSmsBody {
    private List<String> mobiles;
    private List<String> receivers;
    private JSONArray para;

    private BatchSmsBody() {
    }

    public List<String> getMobiles() {
        return this.mobiles;
    }

    public List<String> getReceivers() {
        return this.receivers;
    }

    public JSONArray getPara() {
        return this.para;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public boolean send() throws Exception {
        return SMSManager.getInstance().batchSendSMS(this.getTemplateCode(), this.getMobiles(), this.getPara(), this.getReceivers());
    }

    public static final class Builder {
        private String templateCode;
        private List<String> mobiles;
        private List<String> receivers;
        private JSONArray para;

        private Builder() {
        }

        public Builder templateCode(String templateCode) {
            this.templateCode = templateCode;
            return this;
        }

        public Builder mobiles(List<String> mobiles) {
            this.mobiles = mobiles;
            return this;
        }

        public Builder receivers(List<String> receivers) {
            this.receivers = receivers;
            return this;
        }

        public Builder para(JSONArray para) {
            this.para = para;
            return this;
        }

        public BatchSmsBody build() {
            if (this.templateCode == null) {
                throw new IllegalArgumentException("templateCode should not be null");
            }
            if (this.mobiles == null) {
                throw new IllegalArgumentException("mobiles should not be null");
            }
            if (this.para == null) {
                throw new IllegalArgumentException("para should not be null");
            }
            BatchSmsBody batchSmsBody = new BatchSmsBody();
            batchSmsBody.setTemplateCode(this.templateCode);
            batchSmsBody.receivers = this.receivers;
            batchSmsBody.mobiles = this.mobiles;
            batchSmsBody.para = this.para;
            return batchSmsBody;
        }
    }
}

