/*
 * Decompiled with CFR 0.152.
 */
package com.fanruan.api.util.trans;

import com.fanruan.api.util.trans.BaseSmsBody;
import com.fr.base.sms.SMSManager;
import com.fr.json.JSONObject;
import org.jetbrains.annotations.Nullable;

public class SingleSmsBody
extends BaseSmsBody {
    private String mobile;
    private JSONObject para;
    private String receiver;
    private boolean needRecord;

    private SingleSmsBody() {
    }

    public String getMobile() {
        return this.mobile;
    }

    public JSONObject getPara() {
        return this.para;
    }

    @Nullable
    public String getReceiver() {
        return this.receiver;
    }

    public boolean isNeedRecord() {
        return this.needRecord;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public boolean send() throws Exception {
        return SMSManager.getInstance().sendSMS(this.getTemplateCode(), this.getMobile(), this.getPara(), this.getReceiver(), this.isNeedRecord());
    }

    public static final class Builder {
        private String templateCode;
        private String mobile;
        private JSONObject para;
        private String receiver;
        private boolean needRecord;

        private Builder() {
        }

        public Builder templateCode(String templateCode) {
            this.templateCode = templateCode;
            return this;
        }

        public Builder mobile(String mobile) {
            this.mobile = mobile;
            return this;
        }

        public Builder para(JSONObject para) {
            this.para = para;
            return this;
        }

        public Builder receiver(@Nullable String receiver) {
            this.receiver = receiver;
            return this;
        }

        public Builder needRecord(boolean needRecord) {
            this.needRecord = needRecord;
            return this;
        }

        public SingleSmsBody build() {
            if (this.templateCode == null) {
                throw new IllegalArgumentException("templateCode should not be null");
            }
            if (this.mobile == null) {
                throw new IllegalArgumentException("mobile should not be null");
            }
            if (this.para == null) {
                throw new IllegalArgumentException("para should not be null");
            }
            SingleSmsBody singleSmsBody = new SingleSmsBody();
            singleSmsBody.setTemplateCode(this.templateCode);
            singleSmsBody.para = this.para;
            singleSmsBody.receiver = this.receiver;
            singleSmsBody.needRecord = this.needRecord;
            singleSmsBody.mobile = this.mobile;
            return singleSmsBody;
        }
    }
}

