/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.cache;

import com.fr.third.springframework.cache.support.SimpleCacheManager;
import com.fr.third.springframework.context.annotation.Configuration;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

@Configuration
public class CacheManagerConfig {
    private CacheManagerConfig() {
    }

    public static SimpleCacheManager getSimpleCacheManager() {
        return CacheManager._INSTANCE;
    }

    public static Cache getJDKCache() {
        return JDKCache.cache;
    }

    public static void clearCache() {
        JDKCache.cache.cleanUp();
    }

    public static void clearSeesionCache(String string) throws ExecutionException {
        Cache<String, String> cache = JDKCache.cache;
        if (cache.getIfPresent((Object)string) != null) {
            cache.put((Object)string, null);
        }
    }

    private static class JDKCache {
        public static Cache<String, String> cache = Caffeine.newBuilder().maximumSize(200000L).expireAfterWrite(20L, TimeUnit.MINUTES).build();

        private JDKCache() {
        }
    }

    private static class CacheManager {
        private static final SimpleCacheManager _INSTANCE = new SimpleCacheManager();

        private CacheManager() {
        }
    }
}

