/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.cache;

import com.fr.plugin.util.CollectionUtils;
import com.fr.plugin.util.SQLQueryCollectionUtils;
import com.fr.plugin.util.SqlQueryStatementUtils;
import com.fr.stable.StringUtils;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CaffeineCacheManager {
    private static Pattern pattern = Pattern.compile("#");
    private static LoadingCache<String, List> mainDataBuild = null;
    private static LoadingCache<String, Map> accountSuitBuild = null;
    private static LoadingCache<String, Map> financialAccountBuild = null;
    private static LoadingCache<String, List> accountSubjectBuild = null;
    private static LoadingCache<String, Map> accountSubjectInfoBuild = null;
    private static LoadingCache<String, List> tableBuild = null;
    private static LoadingCache<String, Map> tableInfoBuild = null;
    private static LoadingCache<String, List> voucherAccountSubejctBuild = null;
    private static LoadingCache<String, List> voucherACCFunctionBuild = null;
    private static LoadingCache<String, List> voucherACCFunctionTwoLevelBuild = null;
    private static LoadingCache<String, List> voucherACCFunctionExpNatureBuild = null;
    private static LoadingCache<String, List> voucherACCFunctionExpNatureTwoLevelBuild = null;
    private static LoadingCache<String, List> voucherACCFunctionExpNatureLevelProjectBuild = null;
    private static LoadingCache<String, List> voucherACCFunctionExpNatureLevelDutyClassBuild = null;
    private static LoadingCache<String, List> voucherACCFunctionEconomicBuild = null;
    private static LoadingCache<String, List> voucherACCFunEconTwoLevelBuild = null;
    private static LoadingCache<String, List> voucherACCFunEconExpNatureBuild = null;
    private static LoadingCache<String, List> voucherACCFunEconExpProjecBuild = null;
    private static LoadingCache<String, List> voucherACCFunEconExpDutyClassBuild = null;
    private static LoadingCache<String, List> voucherACCFunEconExpTwoLevelBuild = null;
    private static LoadingCache<String, List> voucherACCFunEconExpLevelProjectBuild = null;
    private static LoadingCache<String, List> voucherACCFunEconExpLevelDutyClassBuild = null;

    public static List getMainData(String string) {
        if (mainDataBuild == null) {
            mainDataBuild = Caffeine.newBuilder().initialCapacity(3).maximumSize(50L).expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List>(){

                public List load(String string) {
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    String[] stringArray = pattern.split(string);
                    Integer n = -1;
                    String string2 = stringArray[0];
                    String string3 = stringArray[1];
                    String string4 = stringArray[2];
                    String string5 = stringArray[3];
                    if (stringArray.length > 4) {
                        n = Integer.valueOf(stringArray[4]);
                    }
                    String string6 = SqlQueryStatementUtils.getJSMainSql(string2, string4, string5, n);
                    List list = SQLQueryCollectionUtils.getList(string3, string6);
                    return Optional.ofNullable(list).orElse(null);
                }
            });
        }
        return (List)mainDataBuild.get((Object)string);
    }

    public static Map getAccountSuit(String string, String string2) {
        if (accountSuitBuild == null) {
            accountSuitBuild = Caffeine.newBuilder().initialCapacity(1).maximumSize(2L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Map>(){

                public Map load(String string) {
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    Map<Object, Map> map2 = null;
                    String string2 = SqlQueryStatementUtils.getAccountSuitSql();
                    List list = SQLQueryCollectionUtils.getList(string, string2);
                    if (CollectionUtils.isNotEmpty(list)) {
                        map2 = list.stream().collect(Collectors.toMap(map -> map.get("id"), map -> map));
                        return Optional.ofNullable(map2).orElse(null);
                    }
                    return Optional.ofNullable(map2).orElse(null);
                }
            });
        }
        Map map2 = Optional.ofNullable(accountSuitBuild.get((Object)string)).map(map -> map.get(string2)).orElse(null);
        return map2;
    }

    public static Map getFinancialAccount(String string, String string2) {
        if (financialAccountBuild == null) {
            financialAccountBuild = Caffeine.newBuilder().initialCapacity(1).maximumSize(2L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Map>(){

                public Map load(String string) {
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    Map<Object, Map> map2 = null;
                    String string2 = SqlQueryStatementUtils.getFinancialAccountSql();
                    List list = SQLQueryCollectionUtils.getList(string, string2);
                    if (CollectionUtils.isNotEmpty(list)) {
                        map2 = list.stream().collect(Collectors.toMap(map -> map.get("id"), map -> map));
                        return Optional.ofNullable(map2).orElse(null);
                    }
                    return Optional.ofNullable(map2).orElse(null);
                }
            });
        }
        Map map2 = Optional.ofNullable(financialAccountBuild.get((Object)string)).map(map -> map.get(string2)).orElse(null);
        return map2;
    }

    public static List getAccountSubjectList(String string, String string2, String string3) {
        if (accountSubjectBuild == null) {
            accountSubjectBuild = Caffeine.newBuilder().initialCapacity(1).maximumSize(20L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List>(){

                public List load(String string) {
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    String[] stringArray = string.split("#");
                    String string2 = stringArray[0];
                    String string3 = stringArray[1];
                    String string4 = stringArray[2];
                    if (StringUtils.isBlank((String)string3) || StringUtils.isBlank((String)string4)) {
                        return null;
                    }
                    String string5 = SqlQueryStatementUtils.getAccountSubjectSql(string3, string4);
                    List list = SQLQueryCollectionUtils.getList(string2, string5);
                    return Optional.ofNullable(list).orElse(null);
                }
            });
        }
        String string4 = string + "#" + string2 + "#" + string3;
        return (List)accountSubjectBuild.get((Object)string4);
    }

    public static Map getAccountSubjectInfo(String string, String string2, String string3, String string4) {
        if (accountSubjectInfoBuild == null) {
            accountSubjectInfoBuild = Caffeine.newBuilder().initialCapacity(200).maximumSize(10000L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Map>(){

                public Map load(String string) {
                    String string2;
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    String[] stringArray = string.split("#");
                    String string3 = stringArray[0];
                    String string4 = stringArray[1];
                    String string5 = stringArray[2];
                    String string6 = stringArray[3];
                    if (StringUtils.isBlank((String)string6)) {
                        return null;
                    }
                    Map map2 = null;
                    List list = CaffeineCacheManager.getAccountSubjectList(string3, string4, string5);
                    if (CollectionUtils.isNotEmpty(list) && (map2 = (Map)list.stream().filter(map -> string6.equals(map.get("code"))).findFirst().orElse(null)) != null && "0".equals(string2 = (String)map2.get("leaf_flag"))) {
                        String string7 = (String)map2.get("id");
                        List list2 = list.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("parent_ids"))) && ((String)map.get("parent_ids")).contains(string7)).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(list2)) {
                            String string8 = list2.stream().filter(map -> "1".equals(map.get("leaf_flag"))).map(map -> (String)map.get("code")).sorted().collect(Collectors.joining(","));
                            map2.put("leafCodes", string8);
                        }
                        map2.put("leafAccountSubjectList", list2);
                    }
                    return Optional.ofNullable(map2).orElse(null);
                }
            });
        }
        String string5 = string + "#" + string2 + "#" + string3 + "#" + string4;
        return (Map)accountSubjectInfoBuild.get((Object)string5);
    }

    public static List getTableList(String string, String string2, String string3) {
        String string4 = string + "#" + string2 + "#" + string3;
        if (tableBuild == null) {
            tableBuild = Caffeine.newBuilder().initialCapacity(10).maximumSize(200L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List>(){

                public List load(String string) {
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    String[] stringArray = string.split("#");
                    String string2 = stringArray[0];
                    String string3 = stringArray[1];
                    String string4 = stringArray[2];
                    if (StringUtils.isBlank((String)string2) || StringUtils.isBlank((String)string3) || StringUtils.isBlank((String)string4)) {
                        return null;
                    }
                    Object var6_6 = null;
                    String string5 = null;
                    string5 = "expense_nature".equals(string4) ? SqlQueryStatementUtils.getExpNatureSql() : ("settlement_pay_type".equals(string4) ? SqlQueryStatementUtils.getPayTypeSql() : SqlQueryStatementUtils.getAssistSql(string4, string3));
                    List list = SQLQueryCollectionUtils.getList(string2, string5);
                    return Optional.ofNullable(list).orElse(null);
                }
            });
        }
        List list = (List)tableBuild.get((Object)string4);
        return list;
    }

    public static Map getTableInfo(String string, String string2, String string3, String string4) {
        String string5 = string + "#" + string2 + "#" + string3 + "#" + string4;
        if (tableInfoBuild == null) {
            tableInfoBuild = Caffeine.newBuilder().initialCapacity(100).maximumSize(50000L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Map>(){

                public Map load(String string) {
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    String[] stringArray = string.split("#");
                    String string2 = stringArray[0];
                    String string3 = stringArray[1];
                    String string4 = stringArray[2];
                    String string5 = stringArray[3];
                    List list = CaffeineCacheManager.getTableList(string2, string3, string4);
                    Map map2 = null;
                    if (CollectionUtils.isNotEmpty(list)) {
                        map2 = list.stream().filter(map -> string5.equals(map.get("code"))).findFirst().orElse(null);
                        if ("RCM_CONFIG_FUNCTION_SUBJECT".equals(string4) || "RCM_CONFIG_OFF_ECONOMIC_CLASS".equals(string4) || "RCM_PROJECT_CATEGORY".equals(string4) || "RCM_CONFIG_DUTY_CLASS".equals(string4)) {
                            String string6;
                            if (map2 != null && "0".equals(string6 = (String)map2.get("leaf_flag"))) {
                                String string7 = (String)map2.get("id");
                                List list2 = list.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("parent_ids"))) && ((String)map.get("parent_ids")).contains(string7)).collect(Collectors.toList());
                                if (CollectionUtils.isNotEmpty(list2)) {
                                    String string8 = list2.stream().filter(map -> "1".equals(map.get("leaf_flag"))).map(map -> (String)map.get("code")).sorted().collect(Collectors.joining(","));
                                    String string9 = list2.stream().filter(map -> "1".equals(map.get("leaf_flag"))).map(map -> (String)map.get("id")).sorted().collect(Collectors.joining(","));
                                    map2.put("leafCodes", string8);
                                    map2.put("leafIds", string9);
                                }
                                map2.put("leafAccountSubjectList", list2);
                            }
                        } else if ("SYS_OFFICE".equals(string4)) {
                            String string10 = (String)map2.get("id");
                            List list3 = list.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("parent_ids"))) && ((String)map.get("parent_ids")).contains(string10)).collect(Collectors.toList());
                            if (CollectionUtils.isNotEmpty(list3)) {
                                String string11 = list3.stream().filter(map -> "1".equals(map.get("leaf_flag"))).map(map -> (String)map.get("code")).sorted().collect(Collectors.joining(","));
                                String string12 = list3.stream().filter(map -> "1".equals(map.get("leaf_flag"))).map(map -> (String)map.get("id")).sorted().collect(Collectors.joining(","));
                                map2.put("leaf_flag", "0");
                                map2.put("leafCodes", string11);
                                map2.put("leafIds", string12);
                                map2.put("leafAccountSubjectList", list3);
                            } else {
                                map2.put("leaf_flag", "1");
                            }
                        }
                    }
                    return Optional.ofNullable(map2).orElse(null);
                }
            });
        }
        return (Map)tableInfoBuild.get((Object)string5);
    }

    public static List getVoucherAccountSubjectInfoList(String string, String string2) {
        String string3 = string + "_" + string2;
        if (voucherAccountSubejctBuild == null) {
            voucherAccountSubejctBuild = Caffeine.newBuilder().initialCapacity(50).maximumSize(5000L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List>(){

                public List load(String string) {
                    Map map2;
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    String[] stringArray = string.split("_");
                    String string2 = stringArray[0];
                    String string3 = stringArray[1];
                    String[] stringArray2 = string2.split("#");
                    String string4 = stringArray2[1];
                    String string5 = stringArray2[2];
                    String string6 = stringArray2[3];
                    Object var9_9 = null;
                    List list = CaffeineCacheManager.getMainData(string2);
                    List list2 = null;
                    if (CollectionUtils.isNotEmpty(list) && (map2 = CaffeineCacheManager.getAccountSubjectInfo(string4, string5, string6, string3)) != null) {
                        String string7 = (String)map2.get("leaf_flag");
                        if ("0".equals(string7)) {
                            String string8 = (String)map2.get("leafCodes");
                            if (StringUtils.isNotBlank((String)string8)) {
                                Set set = Stream.of(string8.split(",")).collect(Collectors.toSet());
                                list2 = list.stream().filter(map -> set.contains(map.get("accountcode"))).collect(Collectors.toList());
                            }
                        } else {
                            list2 = list.stream().filter(map -> string3.equals(map.get("accountcode"))).collect(Collectors.toList());
                        }
                    }
                    return Optional.ofNullable(list2).orElse(null);
                }
            });
        }
        List list = (List)voucherAccountSubejctBuild.get((Object)string3);
        return list;
    }

    public static List getVoucherByFunctionList(String string, String string2, String string3) {
        String string4 = string + "_" + string2 + "_" + string3;
        if (voucherACCFunctionBuild == null) {
            voucherACCFunctionBuild = Caffeine.newBuilder().initialCapacity(100).maximumSize(10000L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List>(){

                public List load(String string) {
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    String[] stringArray = string.split("_");
                    String string2 = stringArray[0];
                    String[] stringArray2 = string2.split("#");
                    String string3 = stringArray2[1];
                    String string4 = stringArray2[2];
                    String string5 = stringArray[1];
                    String string6 = stringArray[2];
                    if (StringUtils.isBlank((String)string6)) {
                        return null;
                    }
                    List list = null;
                    List list2 = CaffeineCacheManager.getVoucherAccountSubjectInfoList(string2, string5);
                    if (CollectionUtils.isNotEmpty(list2)) {
                        if ("NOTNULL".equals(string6)) {
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("fsid")))).collect(Collectors.toList());
                            return Optional.ofNullable(list).orElse(null);
                        }
                        Map map2 = CaffeineCacheManager.getTableInfo(string3, string4, "RCM_CONFIG_FUNCTION_SUBJECT", string6);
                        if (map2 != null) {
                            String string7 = (String)map2.get("id");
                            String string8 = (String)map2.get("leaf_flag");
                            if ("0".equals(string8)) {
                                String string9 = (String)map2.get("leafIds");
                                if (StringUtils.isNotBlank((String)string9)) {
                                    Set set = Stream.of(string9.split(",")).collect(Collectors.toSet());
                                    list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("fsid"))) && set.contains((String)map.get("fsid"))).collect(Collectors.toList());
                                }
                            } else {
                                list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("fsid"))) && string7.equals(map.get("fsid"))).collect(Collectors.toList());
                            }
                        }
                    }
                    return Optional.ofNullable(list).orElse(null);
                }
            });
        }
        List list = (List)voucherACCFunctionBuild.get((Object)string4);
        return list;
    }

    public static List getVoucherByFunctionTwoLevelList(String string, String string2, String string3, String string4) {
        String string5 = string + "_" + string2 + "_" + string3 + "_" + string4;
        if (voucherACCFunctionTwoLevelBuild == null) {
            voucherACCFunctionTwoLevelBuild = Caffeine.newBuilder().initialCapacity(100).maximumSize(30000L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List>(){

                public List load(String string) {
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    String[] stringArray = string.split("_");
                    String string2 = stringArray[0];
                    String[] stringArray2 = string2.split("#");
                    String string3 = stringArray2[1];
                    String string4 = stringArray2[2];
                    String string5 = stringArray[1];
                    String string6 = stringArray[2];
                    String string7 = stringArray[3];
                    if (StringUtils.isBlank((String)string7)) {
                        return null;
                    }
                    List list = null;
                    List list2 = CaffeineCacheManager.getVoucherByFunctionList(string2, string5, string6);
                    if (CollectionUtils.isNotEmpty(list2)) {
                        if ("NOTNULL".equals(string7)) {
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("msid")))).collect(Collectors.toList());
                            return Optional.ofNullable(list).orElse(null);
                        }
                        List list3 = CaffeineCacheManager.getTableList(string3, string4, "RCM_CONFIG_MONEY_SOURCE");
                        if (CollectionUtils.isNotEmpty(list3)) {
                            Set set = list3.stream().filter(map -> string7.equals(map.get("two_level"))).map(map -> (String)map.get("id")).collect(Collectors.toSet());
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("msid"))) && set.contains(map.get("msid"))).collect(Collectors.toList());
                        }
                    }
                    return Optional.ofNullable(list).orElse(null);
                }
            });
        }
        List list = (List)voucherACCFunctionTwoLevelBuild.get((Object)string5);
        return list;
    }

    public static List getVoucherByFunctionExpNatureList(String string, String string2, String string3, String string4) {
        String string5 = string + "_" + string2 + "_" + string3 + "_" + string4;
        if (voucherACCFunctionExpNatureBuild == null) {
            voucherACCFunctionExpNatureBuild = Caffeine.newBuilder().initialCapacity(100).maximumSize(100000L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List>(){

                public List load(String string) {
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    String[] stringArray = string.split("_");
                    String string2 = stringArray[0];
                    String[] stringArray2 = string2.split("#");
                    String string3 = stringArray2[1];
                    String string4 = stringArray2[2];
                    String string5 = stringArray[1];
                    String string6 = stringArray[2];
                    String string7 = stringArray[3];
                    if (StringUtils.isBlank((String)string7)) {
                        return null;
                    }
                    List list = null;
                    List list2 = CaffeineCacheManager.getVoucherByFunctionList(string2, string5, string6);
                    if (CollectionUtils.isNotEmpty(list2)) {
                        if ("NOTNULL".equals(string7)) {
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("expnature")))).collect(Collectors.toList());
                            return Optional.ofNullable(list).orElse(null);
                        }
                        list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("expnature"))) && string7.equals(map.get("expnature"))).collect(Collectors.toList());
                    }
                    return Optional.ofNullable(list).orElse(null);
                }
            });
        }
        List list = (List)voucherACCFunctionExpNatureBuild.get((Object)string5);
        return list;
    }

    public static List getVoucherByFunExpTwoList(String string, String string2, String string3, String string4, String string5) {
        String string6 = string + "_" + string2 + "_" + string3 + "_" + string4 + "_" + string5;
        if (voucherACCFunctionExpNatureTwoLevelBuild == null) {
            voucherACCFunctionExpNatureTwoLevelBuild = Caffeine.newBuilder().initialCapacity(100).maximumSize(200000L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List>(){

                public List load(String string) {
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    String[] stringArray = string.split("_");
                    String string2 = stringArray[0];
                    String[] stringArray2 = string2.split("#");
                    String string3 = stringArray2[1];
                    String string4 = stringArray2[2];
                    String string5 = stringArray[1];
                    String string6 = stringArray[2];
                    String string7 = stringArray[3];
                    String string8 = stringArray[4];
                    if (StringUtils.isBlank((String)string8)) {
                        return null;
                    }
                    List list = null;
                    List list2 = CaffeineCacheManager.getVoucherByFunctionExpNatureList(string2, string5, string6, string7);
                    if (CollectionUtils.isNotEmpty(list2)) {
                        if ("NOTNULL".equals(string8)) {
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("msid")))).collect(Collectors.toList());
                            return Optional.ofNullable(list).orElse(null);
                        }
                        List list3 = CaffeineCacheManager.getTableList(string3, string4, "RCM_CONFIG_MONEY_SOURCE");
                        if (CollectionUtils.isNotEmpty(list3)) {
                            Set set = list3.stream().filter(map -> string8.equals(map.get("two_level"))).map(map -> (String)map.get("id")).collect(Collectors.toSet());
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("msid"))) && set.contains(map.get("msid"))).collect(Collectors.toList());
                        }
                    }
                    return Optional.ofNullable(list).orElse(null);
                }
            });
        }
        List list = (List)voucherACCFunctionExpNatureTwoLevelBuild.get((Object)string6);
        return list;
    }

    public static List getVoucherByFunExpTwoProjectList(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = string + "_" + string2 + "_" + string3 + "_" + string4 + "_" + string5 + "_" + string6;
        if (voucherACCFunctionExpNatureLevelProjectBuild == null) {
            voucherACCFunctionExpNatureLevelProjectBuild = Caffeine.newBuilder().initialCapacity(100).maximumSize(200000L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List>(){

                public List load(String string) {
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    String[] stringArray = string.split("_");
                    String string2 = stringArray[0];
                    String[] stringArray2 = string2.split("#");
                    String string3 = stringArray2[1];
                    String string4 = stringArray2[2];
                    String string5 = stringArray[1];
                    String string6 = stringArray[2];
                    String string7 = stringArray[3];
                    String string8 = stringArray[4];
                    String string9 = stringArray[5];
                    if (StringUtils.isBlank((String)string9)) {
                        return null;
                    }
                    List list = null;
                    List list2 = CaffeineCacheManager.getVoucherByFunExpTwoList(string2, string5, string6, string7, string8);
                    if (CollectionUtils.isNotEmpty(list2)) {
                        if ("NOTNULL".equals(string9)) {
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("projectid")))).collect(Collectors.toList());
                            return Optional.ofNullable(list).orElse(null);
                        }
                        Map map2 = CaffeineCacheManager.getTableInfo(string3, string4, "RCM_PROJECT", string9);
                        if (map2 != null) {
                            String string10 = (String)map2.get("id");
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("projectid"))) && string10.equals(map.get("projectid"))).collect(Collectors.toList());
                        }
                    }
                    return Optional.ofNullable(list).orElse(null);
                }
            });
        }
        List list = (List)voucherACCFunctionExpNatureLevelProjectBuild.get((Object)string7);
        return list;
    }

    public static List getVoucherByFunExpTwoDutyClassList(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = string + "_" + string2 + "_" + string3 + "_" + string4 + "_" + string5 + "_" + string6;
        if (voucherACCFunctionExpNatureLevelDutyClassBuild == null) {
            voucherACCFunctionExpNatureLevelDutyClassBuild = Caffeine.newBuilder().initialCapacity(100).maximumSize(200000L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List>(){

                public List load(String string) {
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    String[] stringArray = string.split("_");
                    String string2 = stringArray[0];
                    String[] stringArray2 = string2.split("#");
                    String string3 = stringArray2[1];
                    String string4 = stringArray2[2];
                    String string5 = stringArray[1];
                    String string6 = stringArray[2];
                    String string7 = stringArray[3];
                    String string8 = stringArray[4];
                    String string9 = stringArray[5];
                    if (StringUtils.isBlank((String)string9)) {
                        return null;
                    }
                    List list = null;
                    List list2 = CaffeineCacheManager.getVoucherByFunExpTwoList(string2, string5, string6, string7, string8);
                    if (CollectionUtils.isNotEmpty(list2)) {
                        if ("NOTNULL".equals(string9)) {
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("dutyclassid")))).collect(Collectors.toList());
                            return Optional.ofNullable(list).orElse(null);
                        }
                        Map map2 = CaffeineCacheManager.getTableInfo(string3, string4, "RCM_CONFIG_DUTY_CLASS", string9);
                        if (map2 != null) {
                            String string10 = (String)map2.get("leaf_flag");
                            if ("0".equals(string10)) {
                                String string11 = (String)map2.get("leafIds");
                                if (StringUtils.isNotBlank((String)string11)) {
                                    Set set = Stream.of(string11.split(",")).collect(Collectors.toSet());
                                    list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("dutyclassid"))) && set.contains(map.get("dutyclassid"))).collect(Collectors.toList());
                                }
                            } else {
                                String string12 = (String)map2.get("id");
                                list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("dutyclassid"))) && string12.equals(map.get("dutyclassid"))).collect(Collectors.toList());
                            }
                        }
                    }
                    return Optional.ofNullable(list).orElse(null);
                }
            });
        }
        List list = (List)voucherACCFunctionExpNatureLevelDutyClassBuild.get((Object)string7);
        return list;
    }

    public static List getVoucherByFunctionEconomicList(String string, String string2, String string3, String string4) {
        String string5 = string + "_" + string2 + "_" + string3 + "_" + string4;
        if (voucherACCFunctionEconomicBuild == null) {
            voucherACCFunctionEconomicBuild = Caffeine.newBuilder().initialCapacity(100).maximumSize(200000L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List>(){

                public List load(String string) {
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    String[] stringArray = string.split("_");
                    String string2 = stringArray[0];
                    String[] stringArray2 = string2.split("#");
                    String string3 = stringArray2[1];
                    String string4 = stringArray2[2];
                    String string5 = stringArray[1];
                    String string6 = stringArray[2];
                    String string7 = stringArray[3];
                    if (StringUtils.isBlank((String)string7)) {
                        return null;
                    }
                    List list = null;
                    List list2 = CaffeineCacheManager.getVoucherByFunctionList(string2, string5, string6);
                    if (CollectionUtils.isNotEmpty(list2)) {
                        if ("NOTNULL".equals(string7)) {
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("bpid")))).collect(Collectors.toList());
                            return Optional.ofNullable(list).orElse(null);
                        }
                        Map map2 = CaffeineCacheManager.getTableInfo(string3, string4, "RCM_CONFIG_OFF_ECONOMIC_CLASS", string7);
                        if (map2 != null) {
                            String string8 = (String)map2.get("leaf_flag");
                            if ("0".equals(string8)) {
                                String string9 = (String)map2.get("leafIds");
                                if (StringUtils.isNotBlank((String)string9)) {
                                    Set set = Stream.of(string9.split(",")).collect(Collectors.toSet());
                                    list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("bpid"))) && set.contains(map.get("bpid"))).collect(Collectors.toList());
                                }
                            } else {
                                String string10 = (String)map2.get("id");
                                list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("bpid"))) && string10.equals(map.get("bpid"))).collect(Collectors.toList());
                            }
                        }
                    }
                    return Optional.ofNullable(list).orElse(null);
                }
            });
        }
        List list = (List)voucherACCFunctionEconomicBuild.get((Object)string5);
        return list;
    }

    public static List getVoucherByFunEconTwoLevelList(String string, String string2, String string3, String string4, String string5) {
        String string6 = string + "_" + string2 + "_" + string3 + "_" + string4 + "_" + string5;
        if (voucherACCFunEconTwoLevelBuild == null) {
            voucherACCFunEconTwoLevelBuild = Caffeine.newBuilder().initialCapacity(100).maximumSize(200000L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List>(){

                public List load(String string) {
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    String[] stringArray = string.split("_");
                    String string2 = stringArray[0];
                    String[] stringArray2 = string2.split("#");
                    String string3 = stringArray2[1];
                    String string4 = stringArray2[2];
                    String string5 = stringArray[1];
                    String string6 = stringArray[2];
                    String string7 = stringArray[3];
                    String string8 = stringArray[4];
                    if (StringUtils.isBlank((String)string8)) {
                        return null;
                    }
                    List list = null;
                    List list2 = CaffeineCacheManager.getVoucherByFunctionEconomicList(string2, string5, string6, string7);
                    if (CollectionUtils.isNotEmpty(list2)) {
                        if ("NOTNULL".equals(string8)) {
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("msid")))).collect(Collectors.toList());
                            return Optional.ofNullable(list).orElse(null);
                        }
                        List list3 = CaffeineCacheManager.getTableList(string3, string4, "RCM_CONFIG_MONEY_SOURCE");
                        if (CollectionUtils.isNotEmpty(list3)) {
                            Set set = list3.stream().filter(map -> string8.equals(map.get("two_level"))).map(map -> (String)map.get("id")).collect(Collectors.toSet());
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("msid"))) && set.contains(map.get("msid"))).collect(Collectors.toList());
                        }
                    }
                    return Optional.ofNullable(list).orElse(null);
                }
            });
        }
        List list = (List)voucherACCFunEconTwoLevelBuild.get((Object)string6);
        return list;
    }

    public static List getVoucherByFunEconExpList(String string, String string2, String string3, String string4, String string5) {
        String string6 = string + "_" + string2 + "_" + string3 + "_" + string4 + "_" + string5;
        if (voucherACCFunEconExpNatureBuild == null) {
            voucherACCFunEconExpNatureBuild = Caffeine.newBuilder().initialCapacity(100).maximumSize(200000L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List>(){

                public List load(String string) {
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    String[] stringArray = string.split("_");
                    String string2 = stringArray[0];
                    String[] stringArray2 = string2.split("#");
                    String string3 = stringArray2[1];
                    String string4 = stringArray2[2];
                    String string5 = stringArray[1];
                    String string6 = stringArray[2];
                    String string7 = stringArray[3];
                    String string8 = stringArray[4];
                    if (StringUtils.isBlank((String)string8)) {
                        return null;
                    }
                    List list = null;
                    List list2 = CaffeineCacheManager.getVoucherByFunctionEconomicList(string2, string5, string6, string7);
                    if (CollectionUtils.isNotEmpty(list2)) {
                        if ("NOTNULL".equals(string8)) {
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("expnature")))).collect(Collectors.toList());
                            return Optional.ofNullable(list).orElse(null);
                        }
                        list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("expnature"))) && string8.equals(map.get("expnature"))).collect(Collectors.toList());
                    }
                    return Optional.ofNullable(list).orElse(null);
                }
            });
        }
        List list = (List)voucherACCFunEconExpNatureBuild.get((Object)string6);
        return list;
    }

    public static List getVoucherByFunEconExpProjecList(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = string + "_" + string2 + "_" + string3 + "_" + string4 + "_" + string5 + "_" + string6;
        if (voucherACCFunEconExpProjecBuild == null) {
            voucherACCFunEconExpProjecBuild = Caffeine.newBuilder().initialCapacity(100).maximumSize(200000L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List>(){

                public List load(String string) {
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    String[] stringArray = string.split("_");
                    String string2 = stringArray[0];
                    String[] stringArray2 = string2.split("#");
                    String string3 = stringArray2[1];
                    String string4 = stringArray2[2];
                    String string5 = stringArray[1];
                    String string6 = stringArray[2];
                    String string7 = stringArray[3];
                    String string8 = stringArray[4];
                    String string9 = stringArray[5];
                    if (StringUtils.isBlank((String)string9)) {
                        return null;
                    }
                    List list = null;
                    List list2 = CaffeineCacheManager.getVoucherByFunEconExpList(string2, string5, string6, string7, string8);
                    if (CollectionUtils.isNotEmpty(list2)) {
                        if ("NOTNULL".equals(string9)) {
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("projectid")))).collect(Collectors.toList());
                            return Optional.ofNullable(list).orElse(null);
                        }
                        Map map2 = CaffeineCacheManager.getTableInfo(string3, string4, "RCM_PROJECT", string9);
                        if (map2 != null) {
                            String string10 = (String)map2.get("id");
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("projectid"))) && string10.equals(map.get("projectid"))).collect(Collectors.toList());
                        }
                    }
                    return Optional.ofNullable(list).orElse(null);
                }
            });
        }
        List list = (List)voucherACCFunEconExpProjecBuild.get((Object)string7);
        return list;
    }

    public static List getVoucherByFunEconExpDutyClassList(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = string + "_" + string2 + "_" + string3 + "_" + string4 + "_" + string5 + "_" + string6;
        if (voucherACCFunEconExpDutyClassBuild == null) {
            voucherACCFunEconExpDutyClassBuild = Caffeine.newBuilder().initialCapacity(100).maximumSize(200000L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List>(){

                public List load(String string) {
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    String[] stringArray = string.split("_");
                    String string2 = stringArray[0];
                    String[] stringArray2 = string2.split("#");
                    String string3 = stringArray2[1];
                    String string4 = stringArray2[2];
                    String string5 = stringArray[1];
                    String string6 = stringArray[2];
                    String string7 = stringArray[3];
                    String string8 = stringArray[4];
                    String string9 = stringArray[5];
                    if (StringUtils.isBlank((String)string9)) {
                        return null;
                    }
                    List list = null;
                    List list2 = CaffeineCacheManager.getVoucherByFunEconExpList(string2, string5, string6, string7, string8);
                    if (CollectionUtils.isNotEmpty(list2)) {
                        if ("NOTNULL".equals(string9)) {
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("dutyclassid")))).collect(Collectors.toList());
                            return Optional.ofNullable(list).orElse(null);
                        }
                        Map map2 = CaffeineCacheManager.getTableInfo(string3, string4, "RCM_CONFIG_DUTY_CLASS", string9);
                        if (map2 != null) {
                            String string10 = (String)map2.get("leaf_flag");
                            if ("0".equals(string10)) {
                                String string11 = (String)map2.get("leafIds");
                                if (StringUtils.isNotBlank((String)string11)) {
                                    Set set = Stream.of(string11.split(",")).collect(Collectors.toSet());
                                    list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("dutyclassid"))) && set.contains(map.get("dutyclassid"))).collect(Collectors.toList());
                                }
                            } else {
                                String string12 = (String)map2.get("id");
                                list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("dutyclassid"))) && string12.equals(map.get("dutyclassid"))).collect(Collectors.toList());
                            }
                        }
                    }
                    return Optional.ofNullable(list).orElse(null);
                }
            });
        }
        List list = (List)voucherACCFunEconExpDutyClassBuild.get((Object)string7);
        return list;
    }

    public static List getVoucherByFunEconExpTwoLevelList(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = string + "_" + string2 + "_" + string3 + "_" + string4 + "_" + string5 + "_" + string6;
        if (voucherACCFunEconExpTwoLevelBuild == null) {
            voucherACCFunEconExpTwoLevelBuild = Caffeine.newBuilder().initialCapacity(100).maximumSize(200000L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List>(){

                public List load(String string) {
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    String[] stringArray = string.split("_");
                    String string2 = stringArray[0];
                    String[] stringArray2 = string2.split("#");
                    String string3 = stringArray2[1];
                    String string4 = stringArray2[2];
                    String string5 = stringArray[1];
                    String string6 = stringArray[2];
                    String string7 = stringArray[3];
                    String string8 = stringArray[4];
                    String string9 = stringArray[5];
                    if (StringUtils.isBlank((String)string9)) {
                        return null;
                    }
                    List list = null;
                    List list2 = CaffeineCacheManager.getVoucherByFunEconExpList(string2, string5, string6, string7, string8);
                    if (CollectionUtils.isNotEmpty(list2)) {
                        if ("NOTNULL".equals(string9)) {
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("msid")))).collect(Collectors.toList());
                            return Optional.ofNullable(list).orElse(null);
                        }
                        List list3 = CaffeineCacheManager.getTableList(string3, string4, "RCM_CONFIG_MONEY_SOURCE");
                        if (CollectionUtils.isNotEmpty(list3)) {
                            Set set = list3.stream().filter(map -> string9.equals(map.get("two_level"))).map(map -> (String)map.get("id")).collect(Collectors.toSet());
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("msid"))) && set.contains(map.get("msid"))).collect(Collectors.toList());
                        }
                    }
                    return Optional.ofNullable(list).orElse(null);
                }
            });
        }
        List list = (List)voucherACCFunEconExpTwoLevelBuild.get((Object)string7);
        return list;
    }

    public static List getVoucherByFunEconExpLevelProjectList(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        String string8 = string + "_" + string2 + "_" + string3 + "_" + string4 + "_" + string5 + "_" + string6 + "_" + string7;
        if (voucherACCFunEconExpLevelProjectBuild == null) {
            voucherACCFunEconExpLevelProjectBuild = Caffeine.newBuilder().initialCapacity(100).maximumSize(200000L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List>(){

                public List load(String string) {
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    String[] stringArray = string.split("_");
                    String string2 = stringArray[0];
                    String[] stringArray2 = string2.split("#");
                    String string3 = stringArray2[1];
                    String string4 = stringArray2[2];
                    String string5 = stringArray[1];
                    String string6 = stringArray[2];
                    String string7 = stringArray[3];
                    String string8 = stringArray[4];
                    String string9 = stringArray[5];
                    String string10 = stringArray[6];
                    if (StringUtils.isBlank((String)string10)) {
                        return null;
                    }
                    List list = null;
                    List list2 = CaffeineCacheManager.getVoucherByFunEconExpTwoLevelList(string2, string5, string6, string7, string8, string9);
                    if (CollectionUtils.isNotEmpty(list2)) {
                        if ("NOTNULL".equals(string10)) {
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("projectid")))).collect(Collectors.toList());
                            return Optional.ofNullable(list).orElse(null);
                        }
                        Map map2 = CaffeineCacheManager.getTableInfo(string3, string4, "RCM_PROJECT", string10);
                        if (map2 != null) {
                            String string11 = (String)map2.get("id");
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("projectid"))) && string11.equals(map.get("projectid"))).collect(Collectors.toList());
                        }
                    }
                    return Optional.ofNullable(list).orElse(null);
                }
            });
        }
        List list = (List)voucherACCFunEconExpLevelProjectBuild.get((Object)string8);
        return list;
    }

    public static List getVoucherByFunEconExpLevelDutyClassList(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        String string8 = string + "_" + string2 + "_" + string3 + "_" + string4 + "_" + string5 + "_" + string6 + "_" + string7;
        if (voucherACCFunEconExpLevelDutyClassBuild == null) {
            voucherACCFunEconExpLevelDutyClassBuild = Caffeine.newBuilder().initialCapacity(100).maximumSize(200000L).expireAfterAccess(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List>(){

                public List load(String string) {
                    if (StringUtils.isBlank((String)string)) {
                        return null;
                    }
                    String[] stringArray = string.split("_");
                    String string2 = stringArray[0];
                    String[] stringArray2 = string2.split("#");
                    String string3 = stringArray2[1];
                    String string4 = stringArray2[2];
                    String string5 = stringArray[1];
                    String string6 = stringArray[2];
                    String string7 = stringArray[3];
                    String string8 = stringArray[4];
                    String string9 = stringArray[5];
                    String string10 = stringArray[6];
                    List list = null;
                    if (StringUtils.isBlank((String)string10)) {
                        return null;
                    }
                    List list2 = CaffeineCacheManager.getVoucherByFunEconExpTwoLevelList(string2, string5, string6, string7, string8, string9);
                    if (CollectionUtils.isNotEmpty(list2)) {
                        if ("NOTNULL".equals(string10)) {
                            list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("dutyclassid")))).collect(Collectors.toList());
                            return Optional.ofNullable(list).orElse(null);
                        }
                        Map map2 = CaffeineCacheManager.getTableInfo(string3, string4, "RCM_CONFIG_DUTY_CLASS", string10);
                        if (map2 != null) {
                            String string11 = (String)map2.get("leaf_flag");
                            if ("0".equals(string11)) {
                                String string12 = (String)map2.get("leafIds");
                                if (StringUtils.isNotBlank((String)string12)) {
                                    Set set = Stream.of(string12.split(",")).collect(Collectors.toSet());
                                    list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("dutyclassid"))) && set.contains(map.get("dutyclassid"))).collect(Collectors.toList());
                                }
                            } else {
                                String string13 = (String)map2.get("id");
                                list = list2.stream().filter(map -> StringUtils.isNotBlank((String)((String)map.get("dutyclassid"))) && string13.equals(map.get("dutyclassid"))).collect(Collectors.toList());
                            }
                        }
                    }
                    return Optional.ofNullable(list).orElse(null);
                }
            });
        }
        List list = (List)voucherACCFunEconExpLevelDutyClassBuild.get((Object)string8);
        return list;
    }

    public static void getCacheStats() {
        System.out.println("################MainData#################" + mainDataBuild.stats().toString());
        System.out.println("################AccountSuit#################" + accountSuitBuild.stats().toString());
        System.out.println("################FinancialAccount#################" + financialAccountBuild.stats().toString());
        System.out.println("################AccountSubjectList#################" + accountSubjectBuild.stats().toString());
        System.out.println("################AccountSubjectInfo#################" + accountSubjectInfoBuild.stats().toString());
        System.out.println("################TableList#################" + tableBuild.stats().toString());
        System.out.println("################TableValue#################" + tableInfoBuild.stats().toString());
        System.out.println("################VoucherAccountSubjectInfoList#################" + voucherAccountSubejctBuild.stats().toString());
        System.out.println("################VoucherAccountSubjectInfoList#################" + voucherACCFunctionBuild.stats().toString());
        System.out.println("################VoucherByFunctionTwoLevelList#################" + voucherACCFunctionTwoLevelBuild.stats().toString());
        System.out.println("################VoucherByFunctionDutyClassList#################" + voucherACCFunctionExpNatureBuild.stats().toString());
        System.out.println("################VoucherByFunExpTwoList#################" + voucherACCFunctionExpNatureTwoLevelBuild.stats().toString());
        System.out.println("################VoucherByFunExpTwoList#################" + voucherACCFunctionExpNatureLevelProjectBuild.stats().toString());
        System.out.println("################VoucherByFunExpTwoList#################" + voucherACCFunctionExpNatureLevelDutyClassBuild.stats().toString());
        System.out.println("################VoucherByFunctionEconomicList#################" + voucherACCFunctionEconomicBuild.stats().toString());
        System.out.println("################VoucherByFunEconTwoLevelList#################" + voucherACCFunEconTwoLevelBuild.stats().toString());
        System.out.println("################VoucherByFunEconExpList#################" + voucherACCFunEconExpNatureBuild.stats().toString());
        System.out.println("################VoucherByFunEconExpProjecList#################" + voucherACCFunEconExpProjecBuild.stats().toString());
        System.out.println("################VoucherByFunEconExpDutyClassList#################" + voucherACCFunEconExpDutyClassBuild.stats().toString());
        System.out.println("################VoucherByFunEconExpTwoLevelList#################" + voucherACCFunEconExpTwoLevelBuild.stats().toString());
        System.out.println("################VoucherByFunEconExpLevelProjectList#################" + voucherACCFunEconExpLevelProjectBuild.stats().toString());
        System.out.println("################VoucherByFunEconExpLevelDutyClassList#################" + voucherACCFunEconExpLevelDutyClassBuild.stats().toString());
    }

    public static void invalidateAllCache() {
        if (mainDataBuild != null) {
            mainDataBuild.invalidateAll();
        }
        if (accountSuitBuild != null) {
            accountSuitBuild.invalidateAll();
        }
        if (financialAccountBuild != null) {
            financialAccountBuild.invalidateAll();
        }
        if (accountSubjectBuild != null) {
            accountSubjectBuild.invalidateAll();
        }
        if (accountSubjectInfoBuild != null) {
            accountSubjectInfoBuild.invalidateAll();
        }
        if (tableBuild != null) {
            tableBuild.invalidateAll();
        }
        if (voucherAccountSubejctBuild != null) {
            voucherAccountSubejctBuild.invalidateAll();
        }
        if (voucherACCFunctionBuild != null) {
            voucherACCFunctionBuild.invalidateAll();
        }
        if (voucherACCFunctionTwoLevelBuild != null) {
            voucherACCFunctionTwoLevelBuild.invalidateAll();
        }
        if (voucherACCFunctionExpNatureBuild != null) {
            voucherACCFunctionExpNatureBuild.invalidateAll();
        }
        if (voucherACCFunctionExpNatureTwoLevelBuild != null) {
            voucherACCFunctionExpNatureTwoLevelBuild.invalidateAll();
        }
        if (voucherACCFunctionExpNatureLevelProjectBuild != null) {
            voucherACCFunctionExpNatureLevelProjectBuild.invalidateAll();
        }
        if (voucherACCFunctionExpNatureLevelDutyClassBuild != null) {
            voucherACCFunctionExpNatureLevelDutyClassBuild.invalidateAll();
        }
        if (voucherACCFunctionEconomicBuild != null) {
            voucherACCFunctionEconomicBuild.invalidateAll();
        }
        if (voucherACCFunEconTwoLevelBuild != null) {
            voucherACCFunEconTwoLevelBuild.invalidateAll();
        }
        if (voucherACCFunEconExpNatureBuild != null) {
            voucherACCFunEconExpNatureBuild.invalidateAll();
        }
        if (voucherACCFunEconExpProjecBuild != null) {
            voucherACCFunEconExpProjecBuild.invalidateAll();
        }
        if (voucherACCFunEconExpDutyClassBuild != null) {
            voucherACCFunEconExpDutyClassBuild.invalidateAll();
        }
        if (voucherACCFunEconExpTwoLevelBuild != null) {
            voucherACCFunEconExpTwoLevelBuild.invalidateAll();
        }
        if (voucherACCFunEconExpLevelProjectBuild != null) {
            voucherACCFunEconExpLevelProjectBuild.invalidateAll();
        }
        if (voucherACCFunEconExpLevelDutyClassBuild != null) {
            voucherACCFunEconExpLevelDutyClassBuild.invalidateAll();
        }
    }
}

