/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis;

import com.fanruan.api.cal.FormulaKit;
import com.fanruan.api.data.ConnectionKit;
import com.fanruan.api.data.TableDataKit;
import com.fanruan.api.util.StringKit;
import com.fr.data.impl.Connection;
import com.fr.decision.fun.impl.AbstractUniversalServerTableDataProvider;
import com.fr.json.JSONObject;
import com.fr.plugin.db.redis.RedisConnectionComponent;
import com.fr.plugin.db.redis.bean.ParameterBean;
import com.fr.plugin.db.redis.core.RedisScriptTableData;
import com.fr.plugin.db.redis.core.order.impl.FormulaOrderValue;
import com.fr.plugin.db.redis.core.order.impl.NumberOrderValue;
import com.fr.plugin.db.redis.core.script.EngineType;
import com.fr.plugin.db.redis.util.RedisUtils;
import com.fr.script.Calculator;
import com.fr.stable.NameReference;
import com.fr.web.struct.Atom;

public class RedisScriptUniversalTableDataImpl
extends AbstractUniversalServerTableDataProvider<RedisScriptTableData> {
    public Class<RedisScriptTableData> classForTableData() {
        return RedisScriptTableData.class;
    }

    public String nameForTableData() {
        return "RedisScript";
    }

    public JSONObject serialize(RedisScriptTableData redisScriptTableData) {
        JSONObject jSONObject = new JSONObject();
        Connection connection = redisScriptTableData.getDatabase();
        jSONObject.put("database", connection instanceof NameReference ? ((NameReference)connection).getName() : "");
        jSONObject.put("orderValue", ((Object)((Object)redisScriptTableData.getOrderValue())).toString());
        jSONObject.put("script", redisScriptTableData.getScript());
        jSONObject.put("engineType", redisScriptTableData.getEngineType().getType());
        jSONObject.put("parameters", ParameterBean.createParameterBeans(redisScriptTableData.getParameters(Calculator.createCalculator())));
        return jSONObject;
    }

    public RedisScriptTableData deserialize(RedisScriptTableData redisScriptTableData, JSONObject jSONObject) {
        RedisScriptTableData redisScriptTableData2 = new RedisScriptTableData();
        String string = jSONObject.getString("database");
        String string2 = jSONObject.getString("script");
        if (!StringKit.isEmpty((String)string) && TableDataKit.findTableData((String)string) != null) {
            redisScriptTableData2.setDatabase(ConnectionKit.createNameConnection((String)string));
        }
        redisScriptTableData2.setEngineType(EngineType.parse(jSONObject.getInt("engineType")));
        redisScriptTableData2.setScript(string2);
        Object object = jSONObject.get("orderValue");
        if (object instanceof Integer) {
            redisScriptTableData2.setOrderValue(new NumberOrderValue((Integer)object));
        } else {
            redisScriptTableData2.setOrderValue(new FormulaOrderValue(FormulaKit.newFormula((Object)object)));
        }
        redisScriptTableData2.setParameters(RedisUtils.analyzeParameter(redisScriptTableData.getParameters(Calculator.createCalculator()), redisScriptTableData2.getOrderValue(), string2));
        return redisScriptTableData2;
    }

    public Atom client() {
        return RedisConnectionComponent.KEY;
    }
}

