/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis;

import com.fr.decision.fun.impl.AbstractUniversalConnectionProvider;
import com.fr.decision.webservice.utils.WebServiceUtils;
import com.fr.json.JSONObject;
import com.fr.plugin.db.redis.RedisConnectionComponent;
import com.fr.plugin.db.redis.core.RedisDatabaseConnection;
import com.fr.plugin.db.redis.core.pool.RedisConnectionPoolConfig;
import com.fr.plugin.db.redis.core.pool.RedisConnectionProxyConfig;
import com.fr.stable.AssistUtils;
import com.fr.transaction.Configurations;
import com.fr.transaction.Worker;
import com.fr.transaction.WorkerAdaptor;
import com.fr.web.struct.Atom;

public class RedisUniversalConnectionImpl
extends AbstractUniversalConnectionProvider<RedisDatabaseConnection> {
    private static final String BASIC_INFO = "basicConfig";
    private static final String POOL_INFO = "poolConfig";
    private static final String PROXY_INFO = "proxyConfig";

    public String nameForConnection() {
        return "Redis";
    }

    public String iconPathForConnection() {
        return "/com/fr/plugin/db/redis/images/redis.png";
    }

    public Class<RedisDatabaseConnection> classForConnection() {
        return RedisDatabaseConnection.class;
    }

    public Atom client() {
        return RedisConnectionComponent.KEY;
    }

    public JSONObject serialize(RedisDatabaseConnection redisDatabaseConnection) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(BASIC_INFO, JSONObject.mapFrom((Object)redisDatabaseConnection.clone()));
            jSONObject.put(POOL_INFO, JSONObject.mapFrom((Object)RedisConnectionPoolConfig.getInstance().clone()));
            JSONObject jSONObject2 = JSONObject.mapFrom((Object)RedisConnectionProxyConfig.getInstance().clone());
            jSONObject2.put("password", "********");
            jSONObject.put(PROXY_INFO, jSONObject2);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return jSONObject;
    }

    public RedisDatabaseConnection deserialize(RedisDatabaseConnection redisDatabaseConnection, JSONObject jSONObject) {
        JSONObject jSONObject2 = this.getRedisDataConnection(jSONObject);
        if (redisDatabaseConnection != null && "********".equals(jSONObject2.getString("password"))) {
            jSONObject2.put("password", redisDatabaseConnection.getPassword());
        } else {
            jSONObject2.put("password", WebServiceUtils.getBase64DecodeStr((String)jSONObject2.getString("password")));
        }
        return (RedisDatabaseConnection)((Object)jSONObject2.mapTo(RedisDatabaseConnection.class));
    }

    private JSONObject getRedisDataConnection(JSONObject jSONObject) {
        Object object;
        JSONObject jSONObject2 = jSONObject.getJSONObject(POOL_INFO);
        if (jSONObject2 != null) {
            object = (RedisConnectionPoolConfig)((Object)jSONObject2.mapTo(RedisConnectionPoolConfig.class));
            Configurations.update((Worker)new WorkerAdaptor(RedisConnectionPoolConfig.class, new Class[0], (RedisConnectionPoolConfig)((Object)object)){
                final /* synthetic */ RedisConnectionPoolConfig val$poolConfig;
                {
                    this.val$poolConfig = redisConnectionPoolConfig;
                    super(clazz, classArray);
                }

                public void run() {
                    RedisConnectionPoolConfig.getInstance().setBlockWhenExhausted(this.val$poolConfig.getBlockWhenExhausted());
                    RedisConnectionPoolConfig.getInstance().setLifo(this.val$poolConfig.getLifo());
                    RedisConnectionPoolConfig.getInstance().setMaxIdle(this.val$poolConfig.getMaxIdle());
                    RedisConnectionPoolConfig.getInstance().setMaxTotal(this.val$poolConfig.getMaxTotal());
                    RedisConnectionPoolConfig.getInstance().setMaxWait(this.val$poolConfig.getMaxWait());
                    RedisConnectionPoolConfig.getInstance().setTimeout(this.val$poolConfig.getTimeout());
                }
            });
        }
        if ((object = jSONObject.getJSONObject(PROXY_INFO)) != null) {
            final RedisConnectionProxyConfig redisConnectionProxyConfig = (RedisConnectionProxyConfig)((Object)object.mapTo(RedisConnectionProxyConfig.class));
            Configurations.update((Worker)new WorkerAdaptor(RedisConnectionProxyConfig.class, new Class[0]){

                public void run() {
                    RedisConnectionProxyConfig.getInstance().setHost(redisConnectionProxyConfig.getHost());
                    RedisConnectionProxyConfig.getInstance().setOpen(redisConnectionProxyConfig.isOpen());
                    if (!AssistUtils.equals((Object)redisConnectionProxyConfig.getPassword(), (Object)"********")) {
                        RedisConnectionProxyConfig.getInstance().setPassword(WebServiceUtils.getBase64DecodeStr((String)redisConnectionProxyConfig.getPassword()));
                    }
                    RedisConnectionProxyConfig.getInstance().setPort(redisConnectionProxyConfig.getPort());
                    RedisConnectionProxyConfig.getInstance().setPrivateKeyPath(redisConnectionProxyConfig.getPrivateKeyPath());
                    RedisConnectionProxyConfig.getInstance().setUsername(redisConnectionProxyConfig.getUsername());
                }
            });
        }
        return jSONObject.getJSONObject(BASIC_INFO);
    }
}

