/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis;

import com.fanruan.api.cal.FormulaKit;
import com.fanruan.api.data.ConnectionKit;
import com.fanruan.api.data.TableDataKit;
import com.fanruan.api.util.StringKit;
import com.fr.data.impl.Connection;
import com.fr.decision.fun.impl.AbstractUniversalServerTableDataProvider;
import com.fr.json.JSONObject;
import com.fr.plugin.db.redis.RedisConnectionComponent;
import com.fr.plugin.db.redis.bean.ParameterBean;
import com.fr.plugin.db.redis.core.RedisTableData;
import com.fr.plugin.db.redis.core.order.impl.FormulaOrderValue;
import com.fr.plugin.db.redis.core.order.impl.NumberOrderValue;
import com.fr.plugin.db.redis.util.RedisUtils;
import com.fr.script.Calculator;
import com.fr.stable.NameReference;
import com.fr.web.struct.Atom;

public class RedisUniversalTableDataImpl
extends AbstractUniversalServerTableDataProvider<RedisTableData> {
    public Class<RedisTableData> classForTableData() {
        return RedisTableData.class;
    }

    public String nameForTableData() {
        return "Redis";
    }

    public JSONObject serialize(RedisTableData redisTableData) {
        JSONObject jSONObject = new JSONObject();
        Connection connection = redisTableData.getDatabase();
        jSONObject.put("database", connection instanceof NameReference ? ((NameReference)connection).getName() : "");
        jSONObject.put("orderValue", ((Object)((Object)redisTableData.getOrderValue())).toString());
        jSONObject.put("script", redisTableData.getScript());
        jSONObject.put("query", redisTableData.getQuery());
        jSONObject.put("parameters", ParameterBean.createParameterBeans(redisTableData.getParameters(Calculator.createCalculator())));
        return jSONObject;
    }

    public RedisTableData deserialize(RedisTableData redisTableData, JSONObject jSONObject) {
        RedisTableData redisTableData2 = redisTableData;
        String string = jSONObject.getString("database");
        String string2 = jSONObject.getString("script");
        String string3 = jSONObject.getString("query");
        if (!StringKit.isEmpty((String)string) && TableDataKit.findTableData((String)string) != null) {
            redisTableData2.setDatabase(ConnectionKit.createNameConnection((String)string));
        }
        redisTableData2.setScript(string2);
        redisTableData2.setQuery(string3);
        Object object = jSONObject.get("orderValue");
        if (object instanceof Integer) {
            redisTableData2.setOrderValue(new NumberOrderValue((Integer)object));
        } else {
            redisTableData2.setOrderValue(new FormulaOrderValue(FormulaKit.newFormula((Object)object)));
        }
        redisTableData2.setParameters(RedisUtils.analyzeParameter(redisTableData.getParameters(Calculator.createCalculator()), redisTableData2.getOrderValue(), string2, string3));
        return redisTableData2;
    }

    public Atom client() {
        return RedisConnectionComponent.KEY;
    }
}

