/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.core;

import com.fanruan.api.log.LogKit;
import com.fanruan.api.runtime.EnvKit;
import com.fanruan.api.script.ScriptKit;
import com.fanruan.api.util.GeneralKit;
import com.fanruan.api.util.IOKit;
import com.fanruan.api.util.StringKit;
import com.fr.plugin.db.redis.core.RedisConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.ScriptException;

public class DataWrapper<T> {
    public static DataWrapper EMPTY = new DataWrapper(null, RedisConstants.DEFAULT_COLUMN_NAMES);
    private List<List<T>> data;
    private String[] columnNames;

    public static <T> DataWrapper<T> create(List<List<T>> list, String[] stringArray) {
        return new DataWrapper<T>(list, stringArray);
    }

    private DataWrapper(List<List<T>> list, String[] stringArray) {
        this.data = list;
        this.columnNames = stringArray;
    }

    public String[] getColumnNames() {
        if (this.columnNames == null) {
            return RedisConstants.DEFAULT_COLUMN_NAMES;
        }
        return this.columnNames;
    }

    public List<List<T>> getData() {
        return this.data;
    }

    public void transform(String string) throws ScriptException {
        Map map;
        Object object;
        if (StringKit.isBlank((String)string)) {
            return;
        }
        String string2 = null;
        if (string.startsWith("file:///")) {
            try {
                object = new FileInputStream(new File(this.readAndRenderScriptFile(string)));
                string2 = IOKit.inputStream2String((InputStream)object);
            }
            catch (Exception exception) {
                LogKit.error((String)exception.getMessage(), (Throwable)exception);
            }
        } else {
            string2 = String.format("(function(){%s})()", string);
        }
        object = ScriptKit.newScriptEngine();
        object.put("$content", this.data);
        object.put("$column", this.columnNames);
        Object object2 = object.eval(string2);
        if (object2 instanceof Map && (map = (Map)object2).containsKey("column") && map.containsKey("content")) {
            Object v = map.get("column");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object object3 : ((Map)v).values()) {
                arrayList.add(GeneralKit.objectToString(object3));
            }
            this.columnNames = arrayList.toArray(new String[0]);
            Iterator iterator = map.get("content");
            if (iterator instanceof Map) {
                Object object3;
                object3 = new ArrayList();
                for (Object v2 : ((Map)((Object)iterator)).values()) {
                    object3.add(this.object2List(v2));
                }
                this.data = object3;
            }
        }
    }

    private List<T> object2List(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (object instanceof Map) {
            for (Object v : ((Map)object).values()) {
                arrayList.add(v);
            }
        } else {
            arrayList.add(object);
        }
        return arrayList;
    }

    private String readAndRenderScriptFile(String string) {
        return string.replaceFirst("\\$ENV_HOME", EnvKit.getCurrent().getPath());
    }
}

