/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.core;

import com.fanruan.api.conf.HolderKit;
import com.fanruan.api.data.open.BaseConnection;
import com.fanruan.api.i18n.I18nKit;
import com.fanruan.api.security.SecurityKit;
import com.fanruan.api.util.ArrayKit;
import com.fanruan.api.util.StringKit;
import com.fanruan.api.util.TypeKit;
import com.fr.config.holder.Conf;
import com.fr.data.impl.Connection;
import com.fr.plugin.db.redis.core.RedisPool;
import com.fr.plugin.db.redis.core.emb.Redis;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.third.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import java.util.Set;

@JsonIgnoreProperties(value={"id", "data", "classInfo", "nameSpace", "driver"})
public class RedisDatabaseConnection
extends BaseConnection {
    private static final int DEFAULT_REDIS_PORT = 6379;
    private Conf<String> host = HolderKit.simple((Object)"");
    private Conf<String> port = HolderKit.simple((Object)String.valueOf(6379));
    private Conf<String> password = HolderKit.simple((Object)"");

    public String getHost() {
        return (String)this.host.get();
    }

    public void setHost(String string) {
        this.host.set((Object)string);
    }

    public String getPort() {
        return (String)this.port.get();
    }

    public void setPort(String string) {
        this.port.set((Object)string);
    }

    public String getPassword() {
        return (String)this.password.get();
    }

    public void setPassword(String string) {
        this.password.set((Object)string);
    }

    public void testConnection() throws Exception {
        try (Redis redis = this.createRedisClient();){
            String string = redis.getClient().ping();
            if (!"pong".equalsIgnoreCase(string)) {
                throw new Exception(string);
            }
        }
    }

    public Redis createRedisClient() {
        return RedisPool.getFinal(this.getHost(), this.getPort(), this.getPassword());
    }

    public String[] summary(String ... stringArray) {
        if (ArrayKit.isEmpty((Object[])stringArray)) {
            return ArrayKit.EMPTY_STRING_ARRAY;
        }
        Redis redis = this.createRedisClient();
        Set<String> set = redis.getClient().keys(stringArray[0]);
        String[] stringArray2 = set.toArray(new String[0]);
        redis.close();
        return stringArray2;
    }

    public String connectMessage(boolean bl) {
        if (bl) {
            return I18nKit.getLocText((String)"Plugin-Redis_Connection_Successfully") + "!";
        }
        return I18nKit.getLocText((String)"Plugin-Redis_Connection_Failed") + "!";
    }

    public void addConnection(List<String> list, String string, Class<? extends Connection>[] classArray) {
        for (Class<? extends Connection> clazz : classArray) {
            if (!TypeKit.classInstanceOf(((Object)((Object)this)).getClass(), clazz)) continue;
            list.add(string);
            break;
        }
    }

    public String getDriver() {
        return null;
    }

    public String getOriginalCharsetName() {
        return null;
    }

    public void setOriginalCharsetName(String string) {
    }

    public String getNewCharsetName() {
        return null;
    }

    public void setNewCharsetName(String string) {
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "Attr".equals(string = xMLableReader.getTagName())) {
            this.setHost(xMLableReader.getAttrAsString("host", ""));
            this.setPort(xMLableReader.getAttrAsString("port", String.valueOf(6379)));
            String string2 = xMLableReader.getAttrAsString("password", "");
            if (StringKit.isNotEmpty((String)string2)) {
                this.setPassword(SecurityKit.encrypt((String)string2));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr");
        xMLPrintWriter.attr("host", this.getHost());
        xMLPrintWriter.attr("port", this.getPort());
        if (StringKit.isNotEmpty((String)this.getPassword())) {
            xMLPrintWriter.attr("password", SecurityKit.decrypt((String)this.getPassword()));
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        RedisDatabaseConnection redisDatabaseConnection = (RedisDatabaseConnection)((Object)super.clone());
        redisDatabaseConnection.host = (Conf)this.host.clone();
        redisDatabaseConnection.port = (Conf)this.port.clone();
        redisDatabaseConnection.password = (Conf)this.password.clone();
        return redisDatabaseConnection;
    }
}

