/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.core;

import com.fanruan.api.conf.ConfigurationKit;
import com.fanruan.api.generic.Matcher;
import com.fanruan.api.generic.Runner;
import com.fanruan.api.log.LogKit;
import com.fanruan.api.util.ArrayKit;
import com.fanruan.api.util.StringKit;
import com.fr.config.Configuration;
import com.fr.plugin.db.redis.core.accessor.category.ClusterRedisClient;
import com.fr.plugin.db.redis.core.accessor.category.StandaloneRedisClient;
import com.fr.plugin.db.redis.core.emb.Redis;
import com.fr.plugin.db.redis.core.emb.impl.ProxyRedis;
import com.fr.plugin.db.redis.core.emb.impl.SimpleRedis;
import com.fr.plugin.db.redis.core.pool.RedisConnectionPoolConfig;
import com.fr.plugin.db.redis.core.pool.RedisConnectionProxyConfig;
import com.fr.stable.collections.combination.Pair;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisPool {
    private static RedisPool pool = new RedisPool();
    private Map<String, JedisPool> jedisPoolMap = new ConcurrentHashMap<String, JedisPool>();

    private void clearAll() {
        this.jedisPoolMap.clear();
    }

    public static Redis getFinal(String string, String string2, String string3) {
        List<Pair<String, Integer>> list = RedisPool.findAllHostAndPassword(string, string2);
        if (list.size() == 1) {
            return pool.getStandaloneResource(list.get(0), string3);
        }
        return pool.getJedisCluster(list, string3);
    }

    public Redis getStandaloneResource(Pair<String, Integer> pair, String string) {
        String string2 = (String)pair.getFirst();
        int n = (Integer)pair.getSecond();
        if (RedisConnectionProxyConfig.getInstance().isOpen()) {
            try {
                return this.createJedisBySSH(string2, n, string);
            }
            catch (JSchException jSchException) {
                LogKit.error((String)jSchException.getMessage(), (Throwable)jSchException);
            }
        } else {
            String string3 = string2 + ":" + n + "@" + string;
            JedisPool jedisPool = this.jedisPoolMap.get(string3);
            if (jedisPool == null) {
                jedisPool = RedisPool.createJedisPool(string2, n, string);
                this.jedisPoolMap.put(string3, jedisPool);
            }
            return new SimpleRedis(new StandaloneRedisClient(jedisPool.getResource()));
        }
        Jedis jedis = new Jedis(string2, n);
        jedis.auth(string);
        return new SimpleRedis(new StandaloneRedisClient(jedis));
    }

    private static JedisPool createJedisPool(String string, int n, String string2) {
        RedisConnectionPoolConfig redisConnectionPoolConfig = RedisConnectionPoolConfig.getInstance();
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(redisConnectionPoolConfig.getMaxTotal());
        jedisPoolConfig.setBlockWhenExhausted(redisConnectionPoolConfig.getBlockWhenExhausted());
        jedisPoolConfig.setJmxEnabled(true);
        jedisPoolConfig.setJmxNamePrefix("pool");
        jedisPoolConfig.setLifo(redisConnectionPoolConfig.getLifo());
        jedisPoolConfig.setMaxIdle(redisConnectionPoolConfig.getMaxIdle());
        jedisPoolConfig.setMaxWaitMillis((long)redisConnectionPoolConfig.getMaxWait());
        jedisPoolConfig.setMinEvictableIdleTimeMillis(1800000L);
        jedisPoolConfig.setMinIdle(0);
        jedisPoolConfig.setNumTestsPerEvictionRun(3);
        jedisPoolConfig.setSoftMinEvictableIdleTimeMillis(1800000L);
        jedisPoolConfig.setTestOnBorrow(false);
        jedisPoolConfig.setTestWhileIdle(false);
        jedisPoolConfig.setTimeBetweenEvictionRunsMillis(-1L);
        if (StringKit.isNotBlank((String)string2)) {
            return new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, string, n, redisConnectionPoolConfig.getTimeout(), string2);
        }
        return new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, string, n, redisConnectionPoolConfig.getTimeout());
    }

    private Redis createJedisBySSH(String string, int n, String string2) throws JSchException {
        RedisConnectionProxyConfig redisConnectionProxyConfig = RedisConnectionProxyConfig.getInstance();
        JSch jSch = new JSch();
        if (StringKit.isNotBlank((String)redisConnectionProxyConfig.getPrivateKeyPath())) {
            jSch.addIdentity(redisConnectionProxyConfig.getPrivateKeyPath());
        }
        Session session = jSch.getSession(redisConnectionProxyConfig.getUsername(), redisConnectionProxyConfig.getHost(), redisConnectionProxyConfig.getPort());
        if (StringKit.isNotBlank((String)redisConnectionProxyConfig.getPassword())) {
            session.setPassword(redisConnectionProxyConfig.getPassword());
        }
        session.setConfig("StrictHostKeyChecking", "no");
        session.connect();
        int n2 = session.setPortForwardingL(0, string, n);
        Jedis jedis = new Jedis(string, n2);
        if (StringKit.isNotBlank((String)string2)) {
            jedis.auth(string2);
        }
        return new ProxyRedis(session, new StandaloneRedisClient(jedis));
    }

    private Redis getJedisCluster(List<Pair<String, Integer>> list, String string) {
        RedisConnectionPoolConfig redisConnectionPoolConfig = RedisConnectionPoolConfig.getInstance();
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setMaxTotal(redisConnectionPoolConfig.getMaxTotal());
        genericObjectPoolConfig.setLifo(redisConnectionPoolConfig.getLifo());
        genericObjectPoolConfig.setMinIdle(1);
        genericObjectPoolConfig.setMaxIdle(redisConnectionPoolConfig.getMaxIdle());
        genericObjectPoolConfig.setMaxWaitMillis((long)redisConnectionPoolConfig.getMaxWait());
        genericObjectPoolConfig.setTimeBetweenEvictionRunsMillis(-1L);
        genericObjectPoolConfig.setTestOnBorrow(true);
        genericObjectPoolConfig.setTestOnReturn(true);
        genericObjectPoolConfig.setTestWhileIdle(true);
        genericObjectPoolConfig.setMinEvictableIdleTimeMillis(6000L);
        genericObjectPoolConfig.setTimeBetweenEvictionRunsMillis(30000L);
        LinkedHashSet<HostAndPort> linkedHashSet = new LinkedHashSet<HostAndPort>();
        for (Pair<String, Integer> pair : list) {
            linkedHashSet.add(new HostAndPort((String)pair.getFirst(), ((Integer)pair.getSecond()).intValue()));
        }
        JedisCluster jedisCluster = StringKit.isNotEmpty((String)string) ? new JedisCluster(linkedHashSet, redisConnectionPoolConfig.getTimeout(), 10000, 5, string, genericObjectPoolConfig) : new JedisCluster(linkedHashSet, redisConnectionPoolConfig.getTimeout(), 10000, 5, genericObjectPoolConfig);
        return new SimpleRedis(new ClusterRedisClient(jedisCluster));
    }

    private static List<Pair<String, Integer>> findAllHostAndPassword(String string, String string2) {
        String[] stringArray = string.split(",");
        String[] stringArray2 = string2.split(",");
        int n = ArrayKit.getLength((Object)stringArray);
        ArrayList<Pair<String, Integer>> arrayList = new ArrayList<Pair<String, Integer>>();
        for (int i = 0; i < n; ++i) {
            arrayList.add((Pair<String, Integer>)new Pair((Object)stringArray[i], (Object)Integer.parseInt(stringArray2[i])));
        }
        return arrayList;
    }

    static {
        ConfigurationKit.listenCacheChange((Matcher)new Matcher<Class<? extends Configuration>>(){

            public boolean match(Class clazz) {
                return RedisConnectionPoolConfig.class == clazz;
            }
        }, (Runner)new Runner(){

            public void run() {
                pool.clearAll();
            }
        });
    }
}

