/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.core;

import com.fanruan.api.conf.HolderKit;
import com.fanruan.api.conf.xml.XmlHolderKit;
import com.fanruan.api.data.ConnectionKit;
import com.fanruan.api.data.open.BaseTableData;
import com.fanruan.api.log.LogKit;
import com.fanruan.api.util.StringKit;
import com.fanruan.api.xml.XmlKit;
import com.fr.config.holder.Conf;
import com.fr.data.impl.Connection;
import com.fr.general.data.DataModel;
import com.fr.intelli.record.Focus;
import com.fr.plugin.db.redis.core.RedisDatabaseConnection;
import com.fr.plugin.db.redis.core.RedisScriptTableDataModel;
import com.fr.plugin.db.redis.core.order.OrderValue;
import com.fr.plugin.db.redis.core.order.impl.NumberOrderValue;
import com.fr.plugin.db.redis.core.script.EngineType;
import com.fr.plugin.db.redis.util.RedisUtils;
import com.fr.record.analyzer.EnableMetrics;
import com.fr.script.Calculator;
import com.fr.stable.ParameterProvider;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

@EnableMetrics
public class RedisScriptTableData
extends BaseTableData {
    private static final long serialVersionUID = 1525853354993816818L;
    private Conf<Connection> database = HolderKit.obj(null, Connection.class);
    private Conf<OrderValue> dbIndex = XmlHolderKit.obj((XMLable)new NumberOrderValue(0), OrderValue.class, (String)"OrderValue");
    private Conf<String> script = HolderKit.simple((Object)"");
    private Conf<Integer> engineType = HolderKit.simple((Object)EngineType.JAVA.getType());

    public void setDatabase(Connection connection) {
        this.database.set((Object)connection);
    }

    public Connection getDatabase() {
        return (Connection)this.database.get();
    }

    public OrderValue getOrderValue() {
        return (OrderValue)((Object)this.dbIndex.get());
    }

    public void setOrderValue(OrderValue orderValue) {
        this.dbIndex.set((Object)orderValue);
    }

    public EngineType getEngineType() {
        return EngineType.parse((Integer)this.engineType.get());
    }

    public void setEngineType(EngineType engineType) {
        this.engineType.set((Object)engineType.getType());
    }

    public String getScript() {
        return (String)this.script.get();
    }

    public void setScript(String string) {
        this.script.set((Object)string);
    }

    public void setParameters(ParameterProvider[] parameterProviderArray) {
        super.setDefaultParameters(parameterProviderArray);
    }

    public DataModel createDataModel(Calculator calculator) {
        return this.createDataModel(calculator, -1);
    }

    @Focus(id="com.fr.solution.plugin.db.redis.v10", text="Plugin-Redis_Script_Table_Data")
    public DataModel createDataModel(Calculator calculator, int n) {
        RedisDatabaseConnection redisDatabaseConnection;
        long l = System.currentTimeMillis();
        ParameterProvider[] parameterProviderArray = this.getParameters(calculator);
        Connection connection = (Connection)this.database.get();
        String string = RedisUtils.getName(connection);
        if (StringKit.isNotEmpty((String)string) && (redisDatabaseConnection = (RedisDatabaseConnection)ConnectionKit.getConnection((String)string, RedisDatabaseConnection.class)) != null) {
            OrderValue orderValue = (OrderValue)((Object)this.dbIndex.get());
            EngineType engineType = this.getEngineType();
            RedisScriptTableDataModel redisScriptTableDataModel = new RedisScriptTableDataModel(redisDatabaseConnection, engineType, orderValue == null ? 0 : orderValue.toIndex((CalculatorProvider)calculator, parameterProviderArray), RedisUtils.calculateQuery((String)this.script.get(), parameterProviderArray), n);
            LogKit.info((String)"Build data model spend time {} ms.", (Object[])new Object[]{System.currentTimeMillis() - l});
            return redisScriptTableDataModel;
        }
        return null;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("OrderValue".equals(string)) {
                OrderValue orderValue = (OrderValue)XmlKit.readXMLable((XMLableReader)xMLableReader);
                if (orderValue != null) {
                    this.setOrderValue(orderValue);
                }
            } else if ("Connection".equals(string)) {
                if (xMLableReader.getAttrAsString("class", null) != null) {
                    Connection connection = XmlKit.readXMLConnection((XMLableReader)xMLableReader);
                    this.setDatabase(connection);
                }
            } else if ("Script".equals(string)) {
                String string2 = xMLableReader.getElementValue();
                if (this.isNotNullValue(string2)) {
                    this.setScript(string2);
                }
            } else if ("ScriptAttr".equals(string)) {
                this.setEngineType(EngineType.parse(xMLableReader.getAttrAsInt("engineType", 0)));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        XmlKit.writeXMLable((XMLPrintWriter)xMLPrintWriter, (XMLable)((XMLable)this.dbIndex.get()), (String)"OrderValue");
        if (this.database.get() != null) {
            XmlKit.writeXMLConnection((XMLPrintWriter)xMLPrintWriter, (Connection)((Connection)this.database.get()));
        }
        xMLPrintWriter.startTAG("Script").textNode(this.getScript()).end();
        xMLPrintWriter.startTAG("ScriptAttr").attr("engineType", ((Integer)this.engineType.get()).intValue()).end();
    }

    private boolean isNotNullValue(String string) {
        return string != null && !"null".equals(string);
    }

    public Object clone() throws CloneNotSupportedException {
        RedisScriptTableData redisScriptTableData = (RedisScriptTableData)((Object)super.clone());
        redisScriptTableData.database = (Conf)this.database.clone();
        redisScriptTableData.script = (Conf)this.script.clone();
        redisScriptTableData.dbIndex = (Conf)this.dbIndex.clone();
        redisScriptTableData.engineType = (Conf)this.engineType.clone();
        return redisScriptTableData;
    }
}

