/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.core;

import com.fanruan.api.data.open.BaseDataModel;
import com.fr.plugin.db.redis.core.RedisDatabaseConnection;
import com.fr.plugin.db.redis.core.emb.Redis;
import com.fr.plugin.db.redis.core.script.EngineType;
import com.fr.plugin.db.redis.help.RedisClient;
import com.fr.plugin.db.redis.help.RedisClientSelector;
import com.fr.plugin.db.redis.help.client.SimpleDataModel;
import java.util.ArrayList;
import java.util.List;

public class RedisScriptTableDataModel
extends BaseDataModel {
    private RedisDatabaseConnection mc;
    private EngineType engineType;
    private String script;
    private int dbIndex;
    private int rowCount;
    private List<List<Object>> data = new ArrayList<List<Object>>();
    private String[] columnNames = null;

    public RedisScriptTableDataModel(RedisDatabaseConnection redisDatabaseConnection, EngineType engineType, int n, String string, int n2) {
        this.mc = redisDatabaseConnection;
        this.engineType = engineType;
        this.script = string;
        this.dbIndex = n;
        this.rowCount = n2;
    }

    private void buildData() {
        if (this.columnNames != null) {
            return;
        }
        Redis redis = this.mc.createRedisClient();
        redis.getClient().select(this.dbIndex);
        RedisClient redisClient = RedisClientSelector.select(redis, this.engineType);
        SimpleDataModel simpleDataModel = redisClient.build(redis, this.script, this.rowCount);
        if (simpleDataModel != null) {
            this.columnNames = simpleDataModel.getColumnNames();
            this.data = simpleDataModel.getData();
            this.rowCount = simpleDataModel.getRowCount();
        }
    }

    public int getColumnCount() {
        this.buildData();
        return this.columnNames == null ? 0 : this.columnNames.length;
    }

    public String getColumnName(int n) {
        this.buildData();
        return this.columnNames == null ? null : this.columnNames[n];
    }

    public int getRowCount() {
        this.buildData();
        return this.data.size();
    }

    public Object getValueAt(int n, int n2) {
        List<Object> list;
        this.buildData();
        if (this.data != null && this.data.size() > n && (list = this.data.get(n)) != null && list.size() > n2) {
            return list.get(n2);
        }
        return null;
    }

    public void release() throws Exception {
    }
}

