/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.core;

import com.fanruan.api.conf.HolderKit;
import com.fanruan.api.conf.xml.XmlHolderKit;
import com.fanruan.api.data.ConnectionKit;
import com.fanruan.api.data.open.BaseTableData;
import com.fanruan.api.log.LogKit;
import com.fanruan.api.util.StringKit;
import com.fanruan.api.xml.XmlKit;
import com.fr.config.holder.Conf;
import com.fr.data.impl.Connection;
import com.fr.general.data.DataModel;
import com.fr.intelli.record.Focus;
import com.fr.intelli.record.Original;
import com.fr.plugin.db.redis.core.RedisDatabaseConnection;
import com.fr.plugin.db.redis.core.RedisTableDataModel;
import com.fr.plugin.db.redis.core.order.OrderValue;
import com.fr.plugin.db.redis.core.order.impl.NumberOrderValue;
import com.fr.plugin.db.redis.util.RedisUtils;
import com.fr.record.analyzer.EnableMetrics;
import com.fr.script.Calculator;
import com.fr.stable.ParameterProvider;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

@EnableMetrics
public class RedisTableData
extends BaseTableData {
    private static final long serialVersionUID = 7017455818551800001L;
    private Conf<Connection> database = HolderKit.obj(null, Connection.class);
    private Conf<OrderValue> dbIndex = XmlHolderKit.obj((XMLable)new NumberOrderValue(0), OrderValue.class, (String)"OrderValue");
    private Conf<String> query = HolderKit.simple((Object)"");
    private Conf<String> script = HolderKit.simple((Object)"");

    public void setDatabase(Connection connection) {
        this.database.set((Object)connection);
    }

    public Connection getDatabase() {
        return (Connection)this.database.get();
    }

    public OrderValue getOrderValue() {
        return (OrderValue)((Object)this.dbIndex.get());
    }

    public void setOrderValue(OrderValue orderValue) {
        this.dbIndex.set((Object)orderValue);
    }

    public String getQuery() {
        return (String)this.query.get();
    }

    public void setQuery(String string) {
        this.query.set((Object)string);
    }

    public String getScript() {
        return (String)this.script.get();
    }

    public void setScript(String string) {
        this.script.set((Object)string);
    }

    public void setParameters(ParameterProvider[] parameterProviderArray) {
        super.setDefaultParameters(parameterProviderArray);
    }

    public DataModel createDataModel(Calculator calculator) {
        return this.createDataModel(calculator, -1);
    }

    @Focus(id="com.fr.solution.plugin.db.redis.v10", text="Plugin-Redis_DB", source=Original.PLUGIN)
    public DataModel createDataModel(Calculator calculator, int n) {
        RedisDatabaseConnection redisDatabaseConnection;
        long l = System.currentTimeMillis();
        ParameterProvider[] parameterProviderArray = this.getParameters(calculator);
        Connection connection = (Connection)this.database.get();
        String string = RedisUtils.getName(connection);
        if (StringKit.isNotEmpty((String)string) && (redisDatabaseConnection = (RedisDatabaseConnection)ConnectionKit.getConnection((String)string, RedisDatabaseConnection.class)) != null) {
            OrderValue orderValue = (OrderValue)((Object)this.dbIndex.get());
            RedisTableDataModel redisTableDataModel = new RedisTableDataModel((CalculatorProvider)calculator, parameterProviderArray, redisDatabaseConnection, orderValue == null ? 0 : orderValue.toIndex((CalculatorProvider)calculator, parameterProviderArray), RedisUtils.calculateQuery((String)this.query.get(), parameterProviderArray), RedisUtils.calculateQuery((String)this.script.get(), parameterProviderArray), n);
            LogKit.info((String)"Build data model spend time {} ms.", (Object[])new Object[]{System.currentTimeMillis() - l});
            return redisTableDataModel;
        }
        return null;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("OrderValue".equals(string2)) {
                OrderValue orderValue = (OrderValue)XmlKit.readXMLable((XMLableReader)xMLableReader);
                if (orderValue != null) {
                    this.setOrderValue(orderValue);
                }
            } else if ("Connection".equals(string2)) {
                if (xMLableReader.getAttrAsString("class", null) != null) {
                    Connection connection = XmlKit.readXMLConnection((XMLableReader)xMLableReader);
                    this.setDatabase(connection);
                }
            } else if ("Query".equals(string2)) {
                String string3 = xMLableReader.getElementValue();
                if (this.isNotNullValue(string3)) {
                    this.setQuery(string3);
                }
            } else if ("Script".equals(string2) && this.isNotNullValue(string = xMLableReader.getElementValue())) {
                this.setScript(string);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        XmlKit.writeXMLable((XMLPrintWriter)xMLPrintWriter, (XMLable)((XMLable)this.dbIndex.get()), (String)"OrderValue");
        if (this.database.get() != null) {
            XmlKit.writeXMLConnection((XMLPrintWriter)xMLPrintWriter, (Connection)((Connection)this.database.get()));
        }
        xMLPrintWriter.startTAG("Query").textNode(this.getQuery()).end();
        xMLPrintWriter.startTAG("Script").textNode(this.getScript()).end();
    }

    private boolean isNotNullValue(String string) {
        return string != null && !"null".equals(string);
    }

    public Object clone() throws CloneNotSupportedException {
        RedisTableData redisTableData = (RedisTableData)((Object)super.clone());
        redisTableData.database = (Conf)this.database.clone();
        redisTableData.query = (Conf)this.query.clone();
        redisTableData.script = (Conf)this.script.clone();
        redisTableData.dbIndex = (Conf)this.dbIndex.clone();
        return redisTableData;
    }
}

