/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.core;

import com.fanruan.api.data.open.BaseDataModel;
import com.fanruan.api.log.LogKit;
import com.fanruan.api.util.StringKit;
import com.fr.plugin.context.PluginContexts;
import com.fr.plugin.db.redis.core.DataWrapper;
import com.fr.plugin.db.redis.core.RedisDatabaseConnection;
import com.fr.plugin.db.redis.core.emb.Redis;
import com.fr.plugin.db.redis.core.visit.VisitorFactory;
import com.fr.stable.ParameterProvider;
import com.fr.stable.script.CalculatorProvider;
import java.util.List;

public class RedisTableDataModel
extends BaseDataModel {
    private String[] columnNames;
    private List<List<Object>> data;

    public RedisTableDataModel(CalculatorProvider calculatorProvider, ParameterProvider[] parameterProviderArray, RedisDatabaseConnection redisDatabaseConnection, int n, String string, String string2, int n2) {
        if (!PluginContexts.currentContext().isAvailable()) {
            throw new RuntimeException("Redis Plugin License Expired!");
        }
        this.initRedisData(calculatorProvider, parameterProviderArray, redisDatabaseConnection, n, string, string2, n2);
    }

    private void initRedisData(CalculatorProvider calculatorProvider, ParameterProvider[] parameterProviderArray, RedisDatabaseConnection redisDatabaseConnection, int n, String string, String string2, int n2) {
        if (StringKit.isEmpty((String)string)) {
            return;
        }
        Redis redis = redisDatabaseConnection.createRedisClient();
        redis.getClient().select(n);
        LogKit.info((String)("Connect to redis and select database:" + n));
        try {
            long l = System.currentTimeMillis();
            DataWrapper dataWrapper = VisitorFactory.getKeyValueResult(calculatorProvider, parameterProviderArray, redis.getClient(), string, n2);
            LogKit.info((String)"Fetch data from redis spend time {} ms.", (Object[])new Object[]{System.currentTimeMillis() - l});
            dataWrapper.transform(string2);
            this.data = dataWrapper.getData();
            this.columnNames = dataWrapper.getColumnNames();
            redis.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getCause());
        }
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public boolean hasRow(int n) {
        return this.data != null && this.data.get(0).size() > n;
    }

    public int getRowCount() {
        return this.data == null ? 0 : this.data.get(0).size();
    }

    public Object getValueAt(int n, int n2) {
        List<Object> list;
        if (this.data != null && this.data.size() > n2 && (list = this.data.get(n2)) != null && list.size() > n) {
            return list.get(n);
        }
        return null;
    }

    public void release() throws Exception {
    }
}

