/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.core.order.impl;

import com.fanruan.api.cal.FormulaKit;
import com.fanruan.api.cal.ParameterKit;
import com.fanruan.api.log.LogKit;
import com.fanruan.api.util.GeneralKit;
import com.fr.base.BaseFormula;
import com.fr.plugin.db.redis.core.order.OrderValue;
import com.fr.stable.ParameterProvider;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.NameSpace;
import com.fr.stable.xml.XMLableReader;

public class FormulaOrderValue
extends OrderValue {
    private BaseFormula formula;

    public FormulaOrderValue() {
    }

    public FormulaOrderValue(BaseFormula baseFormula) {
        this.formula = baseFormula;
    }

    public void setValue(BaseFormula baseFormula) {
        this.formula = baseFormula;
    }

    public BaseFormula getValue() {
        return this.formula;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int toIndex(CalculatorProvider calculatorProvider, ParameterProvider[] parameterProviderArray) {
        NameSpace nameSpace = ParameterKit.createParameterMapNameSpace((ParameterProvider[])parameterProviderArray);
        calculatorProvider.pushNameSpace(nameSpace);
        try {
            int n = GeneralKit.objectToNumber((Object)this.formula.eval(calculatorProvider)).intValue();
            return n;
        }
        catch (Exception exception) {
            LogKit.error((String)exception.getMessage(), (Throwable)exception);
        }
        finally {
            calculatorProvider.removeNameSpace(nameSpace);
        }
        return 0;
    }

    @Override
    public ParameterProvider[] analyze4Parameters() {
        if (this.formula == null) {
            return new ParameterProvider[0];
        }
        return ParameterKit.analyze4ParametersFromFormula((String)this.formula.getContent());
    }

    @Override
    public void readValue(XMLableReader xMLableReader) {
        this.formula = FormulaKit.newFormula((Object)xMLableReader.getAttrAsString("value", ""));
    }

    public String toString() {
        return this.formula == null ? "" : this.formula.getPureContent();
    }
}

