/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.core.visit;

import com.fr.plugin.db.redis.core.DataWrapper;
import com.fr.plugin.db.redis.core.accessor.EmbedRedis;
import com.fr.plugin.db.redis.core.visit.Visitor;
import com.fr.plugin.db.redis.core.visit.impl.GetVisitor;
import com.fr.plugin.db.redis.core.visit.impl.HashGetVisitor;
import com.fr.plugin.db.redis.core.visit.impl.HashKeysVisitor;
import com.fr.plugin.db.redis.core.visit.impl.HashMGetVisitor;
import com.fr.plugin.db.redis.core.visit.impl.HashVisitor;
import com.fr.plugin.db.redis.core.visit.impl.KeysVisitor;
import com.fr.plugin.db.redis.core.visit.impl.ListVisitor;
import com.fr.plugin.db.redis.core.visit.impl.MGetVisitor;
import com.fr.plugin.db.redis.core.visit.impl.SetVisitor;
import com.fr.plugin.db.redis.core.visit.impl.ZRangeVisitor;
import com.fr.stable.ParameterProvider;
import com.fr.stable.script.CalculatorProvider;
import java.util.ArrayList;
import java.util.List;

public class VisitorFactory {
    private static List<Visitor> visitors = new ArrayList<Visitor>();

    public static <T> DataWrapper<T> getKeyValueResult(CalculatorProvider calculatorProvider, ParameterProvider[] parameterProviderArray, EmbedRedis embedRedis, String string, int n) throws Exception {
        Visitor visitor = VisitorFactory.getMatchedVisitor(string);
        if (visitor == null) {
            return DataWrapper.EMPTY;
        }
        return visitor.buildData(calculatorProvider, parameterProviderArray, embedRedis, string, n);
    }

    private static Visitor getMatchedVisitor(String string) {
        for (Visitor visitor : visitors) {
            if (!visitor.match(string)) continue;
            return visitor;
        }
        return null;
    }

    static {
        visitors.add(new GetVisitor());
        visitors.add(new ListVisitor());
        visitors.add(new HashVisitor());
        visitors.add(new HashGetVisitor());
        visitors.add(new HashMGetVisitor());
        visitors.add(new HashKeysVisitor());
        visitors.add(new SetVisitor());
        visitors.add(new ZRangeVisitor());
        visitors.add(new MGetVisitor());
        visitors.add(new KeysVisitor());
    }
}

