/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.help;

import com.eclipsesource.v8.V8;
import com.fr.plugin.db.redis.core.emb.Redis;
import com.fr.plugin.db.redis.core.script.EngineType;
import com.fr.plugin.db.redis.help.RedisClient;
import com.fr.plugin.db.redis.help.client.RedisNashornClient;
import com.fr.plugin.db.redis.help.client.RedisV8Client;

public class RedisClientSelector {
    private static final boolean SUPPORT_J2V8 = RedisClientSelector.isSupportJ2v8();

    public static boolean isSupportJ2v8() {
        V8 v8;
        try {
            v8 = V8.createV8Runtime();
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
        v8.release();
        return true;
    }

    public static RedisClient select(Redis redis, EngineType engineType) {
        if (engineType == EngineType.JAVA) {
            return new RedisNashornClient(redis.getClient());
        }
        if (SUPPORT_J2V8) {
            return new RedisV8Client(redis.getClient());
        }
        return new RedisNashornClient(redis.getClient());
    }
}

