/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.help.client;

import com.fanruan.api.log.LogKit;
import com.fr.json.JSON;
import com.fr.json.JSONFactory;
import com.fr.json.JSONObject;
import com.fr.plugin.db.redis.core.accessor.EmbedRedis;
import com.fr.plugin.db.redis.help.RedisClient;
import com.fr.plugin.db.redis.help.ScriptBridge;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class BaseRedisClient<A>
implements RedisClient<A> {
    EmbedRedis jedis;

    BaseRedisClient(EmbedRedis embedRedis) {
        this.jedis = embedRedis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ScriptBridge
    public String get(String string) {
        String string2;
        long l = System.currentTimeMillis();
        try {
            string2 = this.jedis.get(string);
        }
        catch (Throwable throwable) {
            LogKit.info((String)"Fetch data from redis spend time {} ms.", (Object[])new Object[]{System.currentTimeMillis() - l});
            throw throwable;
        }
        LogKit.info((String)"Fetch data from redis spend time {} ms.", (Object[])new Object[]{System.currentTimeMillis() - l});
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ScriptBridge
    public String hget(String string, String string2) {
        String string3;
        long l = System.currentTimeMillis();
        try {
            string3 = this.jedis.hget(string, string2);
        }
        catch (Throwable throwable) {
            LogKit.info((String)"Fetch data from redis spend time {} ms.", (Object[])new Object[]{System.currentTimeMillis() - l});
            throw throwable;
        }
        LogKit.info((String)"Fetch data from redis spend time {} ms.", (Object[])new Object[]{System.currentTimeMillis() - l});
        return string3;
    }

    @Override
    @ScriptBridge
    public String hkeys(String string) {
        long l = System.currentTimeMillis();
        Set<String> set = this.jedis.keys(string);
        LogKit.info((String)"Fetch data from redis spend time {} ms.", (Object[])new Object[]{System.currentTimeMillis() - l});
        return this.object2JSONString(set);
    }

    @Override
    @ScriptBridge
    public String hmget(String string, String ... stringArray) {
        long l = System.currentTimeMillis();
        List<String> list = this.jedis.hmget(string, stringArray);
        LogKit.info((String)"Fetch data from redis spend time {} ms.", (Object[])new Object[]{System.currentTimeMillis() - l});
        return this.object2JSONString(list);
    }

    @Override
    @ScriptBridge
    public String hgetAll(String string) {
        long l = System.currentTimeMillis();
        Map<String, String> map = this.jedis.hgetAll(string);
        LogKit.info((String)"Fetch data from redis spend time {} ms.", (Object[])new Object[]{System.currentTimeMillis() - l});
        return this.object2JSONString(map);
    }

    @Override
    @ScriptBridge
    public String keys(String string) {
        long l = System.currentTimeMillis();
        Set<String> set = this.jedis.keys(string);
        LogKit.info((String)"Fetch data from redis spend time {} ms.", (Object[])new Object[]{System.currentTimeMillis() - l});
        return this.object2JSONString(set);
    }

    @Override
    @ScriptBridge
    public String lrange(String string, long l, long l2) {
        long l3 = System.currentTimeMillis();
        List<String> list = this.jedis.lrange(string, l, l2);
        LogKit.info((String)"Fetch data from redis spend time {} ms.", (Object[])new Object[]{System.currentTimeMillis() - l3});
        return this.object2JSONString(list);
    }

    @Override
    @ScriptBridge
    public String smembers(String string) {
        long l = System.currentTimeMillis();
        Set<String> set = this.jedis.smembers(string);
        LogKit.info((String)"Fetch data from redis spend time {} ms.", (Object[])new Object[]{System.currentTimeMillis() - l});
        return this.object2JSONString(set);
    }

    String object2JSONString(Collection<String> collection) {
        return JSONFactory.createJSON(collection).toString();
    }

    String object2JSONString(Map<String, String> map) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.putAll(map);
        return ((JSONObject)JSONFactory.createJSON((JSON)JSON.OBJECT, treeMap)).toString();
    }
}

