/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.help.client;

import com.fanruan.api.log.LogKit;
import com.fr.plugin.db.redis.core.accessor.EmbedRedis;
import com.fr.plugin.db.redis.core.emb.Redis;
import com.fr.plugin.db.redis.help.Console;
import com.fr.plugin.db.redis.help.ScriptBridge;
import com.fr.plugin.db.redis.help.client.BaseRedisClient;
import com.fr.plugin.db.redis.help.client.NashornFiles;
import com.fr.plugin.db.redis.help.client.SimpleDataModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class RedisNashornClient
extends BaseRedisClient<Object[]> {
    private static final String PREPARE_SCRIPT = "function unique(array) {var res = [];for (var i = 0, arrayLen = array.length; i < arrayLen; i++) {for (var j = 0, resLen = res.length; j < resLen; j++ ) {if (array[i] === res[j]) {break;}} if (j === resLen) {res.push(array[i])}} return res;}\nfunction merge(table, column) {return {content:table, column:column}};";
    private ScriptEngine scriptEngine = RedisNashornClient.findScriptEngine();

    public RedisNashornClient(EmbedRedis embedRedis) {
        super(embedRedis);
    }

    @Override
    @ScriptBridge
    public String mget(Object[] objectArray) {
        long l = System.currentTimeMillis();
        int n = objectArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = String.valueOf(objectArray[i]);
        }
        List<String> list = this.jedis.mget(stringArray);
        LogKit.info((String)"Fetch data from redis spend time {} ms.", (Object[])new Object[]{System.currentTimeMillis() - l});
        return this.object2JSONString(list);
    }

    @Override
    public SimpleDataModel build(Redis redis, String string, int n) {
        this.scriptEngine.put("console", new Console());
        this.scriptEngine.put("Files", new NashornFiles(this.scriptEngine));
        this.scriptEngine.put("redis", new RedisNashornClient(redis.getClient()));
        try {
            this.scriptEngine.eval(PREPARE_SCRIPT);
            Map map = (Map)this.scriptEngine.eval("(function(){" + string + "})();");
            Map map2 = (Map)map.get("column");
            int n2 = map2.size();
            String[] stringArray = new String[n2];
            int n3 = 0;
            for (Map.Entry entry : map2.entrySet()) {
                stringArray[n3] = String.valueOf(entry.getValue());
                ++n3;
            }
            Map map3 = (Map)map.get("content");
            int n4 = map3.size();
            int n5 = n == -1 ? n4 : Math.min(n4, n);
            ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>();
            int n6 = 0;
            for (Map.Entry entry : map3.entrySet()) {
                Object[] objectArray;
                if (n6 >= n5) break;
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                Object v = entry.getValue();
                if (v instanceof Map) {
                    objectArray = (Object[])entry.getValue();
                    for (Map.Entry entry2 : objectArray.entrySet()) {
                        arrayList2.add(entry2.getValue());
                    }
                } else if (v instanceof Object[]) {
                    objectArray = (Object[])v;
                    arrayList2.addAll(Arrays.asList(objectArray));
                }
                arrayList.add(arrayList2);
                ++n6;
            }
            return new SimpleDataModel(stringArray, arrayList, n5);
        }
        catch (ScriptException scriptException) {
            LogKit.error((String)scriptException.getMessage(), (Throwable)scriptException);
            return null;
        }
    }

    private static ScriptEngine findScriptEngine() {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("nashorn");
        if (scriptEngine == null) {
            List<ScriptEngineFactory> list = scriptEngineManager.getEngineFactories();
            for (ScriptEngineFactory scriptEngineFactory : list) {
                ScriptEngine scriptEngine2 = scriptEngineFactory.getScriptEngine();
                if (scriptEngine2 == null) continue;
                scriptEngine = scriptEngine2;
            }
        }
        return scriptEngine;
    }
}

