/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.help.client;

import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8Value;
import com.fanruan.api.log.LogKit;
import com.fr.plugin.db.redis.core.accessor.EmbedRedis;
import com.fr.plugin.db.redis.core.emb.Redis;
import com.fr.plugin.db.redis.help.Console;
import com.fr.plugin.db.redis.help.ScriptBridge;
import com.fr.plugin.db.redis.help.client.BaseRedisClient;
import com.fr.plugin.db.redis.help.client.SimpleDataModel;
import com.fr.plugin.db.redis.help.client.V8Files;
import com.fr.plugin.db.redis.util.RedisUtils;
import java.util.ArrayList;
import java.util.List;

public class RedisV8Client
extends BaseRedisClient<V8Array> {
    private V8 v8 = V8.createV8Runtime();

    public RedisV8Client(EmbedRedis embedRedis) {
        super(embedRedis);
    }

    @Override
    @ScriptBridge
    public String mget(V8Array v8Array) {
        long l = System.currentTimeMillis();
        int n = v8Array.length();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = v8Array.getString(i);
        }
        List<String> list = this.jedis.mget(stringArray);
        LogKit.info((String)"Fetch data from redis spend time {} ms.", (Object[])new Object[]{System.currentTimeMillis() - l});
        v8Array.release();
        return this.object2JSONString(list);
    }

    @Override
    public SimpleDataModel build(Redis redis, String string, int n) {
        int n2;
        RedisV8Client redisV8Client = new RedisV8Client(redis.getClient());
        V8Object v8Object = this.initConsole(this.v8);
        V8Object v8Object2 = this.initRequire(this.v8);
        V8Object v8Object3 = this.initRedis(this.v8, redisV8Client);
        this.v8.executeVoidScript("function unique(array) {return Array.from(new Set(array));};function merge(table, column) {return {content:table, column:column}};");
        V8Object v8Object4 = this.v8.executeObjectScript(String.format("(function(){%s})();", string));
        V8Array v8Array = v8Object4.getArray("column");
        V8Array v8Array2 = v8Object4.getArray("content");
        int n3 = v8Array.length();
        String[] stringArray = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = String.valueOf(v8Array.get(n2));
        }
        n2 = v8Array2.length();
        int n4 = n == -1 ? n2 : Math.min(n2, n);
        ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>();
        for (int i = 0; i < n4; ++i) {
            V8Array v8Array3 = v8Array2.getArray(i);
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            int n5 = v8Array3.length();
            for (int j = 0; j < n5; ++j) {
                arrayList2.add(v8Array3.get(j));
            }
            v8Array3.release();
            arrayList.add(arrayList2);
        }
        redis.close();
        v8Array2.release();
        v8Array.release();
        v8Object4.release();
        v8Object3.release();
        v8Object2.release();
        v8Object.release();
        this.v8.release(true);
        return new SimpleDataModel(stringArray, arrayList, n4);
    }

    private V8Object initConsole(V8 v8) {
        V8Object v8Object = new V8Object(v8);
        v8.add("console", (V8Value)v8Object);
        Console console = new Console();
        RedisUtils.registerJavaMethods(v8Object, console);
        return v8Object;
    }

    private V8Object initRequire(V8 v8) {
        V8Object v8Object = new V8Object(v8);
        v8.add("Files", (V8Value)v8Object);
        V8Files v8Files = new V8Files(v8);
        RedisUtils.registerJavaMethods(v8Object, v8Files);
        return v8Object;
    }

    private V8Object initRedis(V8 v8, RedisV8Client redisV8Client) {
        V8Object v8Object = new V8Object(v8);
        v8.add("redis", (V8Value)v8Object);
        RedisUtils.registerJavaMethods(v8Object, redisV8Client);
        return v8Object;
    }
}

