/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.ui;

import com.fanruan.api.cal.ParameterKit;
import com.fanruan.api.design.DesignKit;
import com.fanruan.api.design.ui.action.UpdateAction;
import com.fanruan.api.design.ui.component.table.UITableEditorPane;
import com.fanruan.api.design.ui.component.table.action.UITableEditAction;
import com.fanruan.api.design.ui.component.table.model.ParameterTableModel;
import com.fanruan.api.design.ui.component.table.model.UITableModelAdapter;
import com.fanruan.api.design.ui.toolbar.ToolBarDef;
import com.fanruan.api.design.work.AbstractTableDataPane;
import com.fanruan.api.util.ArrayKit;
import com.fanruan.api.util.IOKit;
import com.fr.base.TableData;
import com.fr.design.gui.itoolbar.UIToolbar;
import com.fr.design.menu.ShortCut;
import com.fr.plugin.db.redis.core.order.OrderValue;
import com.fr.plugin.db.redis.ui.RedisDBConnectionChosePane;
import com.fr.stable.ParameterProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public abstract class RedisBaseTableDataPane<T extends TableData>
extends AbstractTableDataPane<T> {
    private static final String PREVIEW_BUTTON = DesignKit.i18nText((String)"Plugin-Redis_Preview");
    private static final String REFRESH_BUTTON = DesignKit.i18nText((String)"Plugin-Redis_Refresh");
    protected RedisDBConnectionChosePane chosePane;
    protected UITableEditorPane<ParameterProvider> editorPane;

    public RedisBaseTableDataPane() {
        this.setLayout(new BorderLayout(4, 4));
        Box box = new Box(1);
        JPanel jPanel = new JPanel(new BorderLayout(4, 4));
        JToolBar jToolBar = this.createToolBar();
        jPanel.add((Component)jToolBar, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        ParameterTableModel parameterTableModel = new ParameterTableModel(){

            public UITableEditAction[] createAction() {
                return new UITableEditAction[]{new ParameterTableModel.MoveUpAction((ParameterTableModel)this), new ParameterTableModel.MoveDownAction((ParameterTableModel)this), new RefreshAction()};
            }
        };
        this.editorPane = new UITableEditorPane((UITableModelAdapter)parameterTableModel);
        box.add(jPanel);
        box.add(this.createQueryPane());
        box.add((Component)this.editorPane);
        JPanel jPanel2 = new JPanel(new BorderLayout(4, 4));
        jPanel2.add((Component)box, "Center");
        this.chosePane = new RedisDBConnectionChosePane();
        this.chosePane.setPreferredSize(new Dimension(200, 200));
        jPanel2.add((Component)((Object)this.chosePane), "West");
        this.add(jPanel2, "Center");
    }

    private JToolBar createToolBar() {
        ToolBarDef toolBarDef = new ToolBarDef();
        toolBarDef.addShortCut(new ShortCut[]{new PreviewAction()});
        com.fanruan.api.design.ui.component.UIToolbar uIToolbar = ToolBarDef.createJToolBar();
        toolBarDef.updateToolBar((UIToolbar)uIToolbar);
        return uIToolbar;
    }

    protected String title4PopupWindow() {
        return DesignKit.i18nText((String)"Plugin-Redis_Query");
    }

    protected abstract JComponent createQueryPane();

    protected abstract String[] paramTexts();

    public abstract OrderValue getOrderValue();

    private void refresh() {
        String[] stringArray = this.paramTexts();
        Object[] objectArray = ParameterKit.analyze4Parameters((String[])stringArray, (boolean)false);
        Object[] objectArray2 = this.getOrderValue().analyze4Parameters();
        this.editorPane.populate(ArrayKit.addAll((Object[])objectArray, (Object[])objectArray2));
    }

    private void checkParameter() {
        int n;
        String[] stringArray = this.paramTexts();
        Object[] objectArray = ParameterKit.analyze4Parameters((String[])stringArray, (boolean)false);
        if ((objectArray = (ParameterProvider[])ArrayKit.addAll((Object[])objectArray, (Object[])this.getOrderValue().analyze4Parameters())).length < 1 && this.editorPane.update().size() < 1) {
            return;
        }
        boolean bl = true;
        List list = this.editorPane.update();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < list.size(); ++n) {
            arrayList.add(((ParameterProvider)list.get(n)).getName());
        }
        for (n = 0; n < objectArray.length; ++n) {
            if (arrayList.contains(objectArray[n].getName())) continue;
            bl = false;
            break;
        }
        if (list.size() == objectArray.length && bl) {
            return;
        }
        this.refresh();
    }

    protected class RefreshAction
    extends UITableEditAction {
        public RefreshAction() {
            this.setName(REFRESH_BUTTON);
            this.setSmallIcon(IOKit.readIcon((String)"/com/fr/design/images/control/refresh.png"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RedisBaseTableDataPane.this.refresh();
        }

        public void checkEnabled() {
        }
    }

    private class PreviewAction
    extends UpdateAction {
        public PreviewAction() {
            this.setName(PREVIEW_BUTTON);
            this.setMnemonic('P');
            this.setSmallIcon(IOKit.readIcon((String)"/com/fr/design/images/m_file/preview.png"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RedisBaseTableDataPane.this.checkParameter();
            DesignKit.previewTableData((TableData)((TableData)RedisBaseTableDataPane.this.updateBean()));
        }
    }
}

