/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.ui;

import com.fanruan.api.conf.ConfigurationKit;
import com.fanruan.api.design.DesignKit;
import com.fanruan.api.design.ui.component.UIActionLabel;
import com.fanruan.api.design.ui.component.UIButton;
import com.fanruan.api.design.ui.component.UILabel;
import com.fanruan.api.design.ui.component.UIPasswordField;
import com.fanruan.api.design.ui.component.UITextField;
import com.fanruan.api.design.ui.component.UITitledBorder;
import com.fanruan.api.design.ui.container.BasicDialog;
import com.fanruan.api.design.ui.layout.TableLayoutKit;
import com.fanruan.api.design.util.GUICoreKit;
import com.fanruan.api.design.work.DatabaseConnectionPane;
import com.fanruan.api.generic.Runner;
import com.fanruan.api.util.IOKit;
import com.fr.design.dialog.DialogActionAdapter;
import com.fr.design.dialog.DialogActionListener;
import com.fr.plugin.db.redis.core.RedisDatabaseConnection;
import com.fr.plugin.db.redis.core.pool.RedisConnectionPoolConfig;
import com.fr.plugin.db.redis.core.pool.RedisConnectionProxyConfig;
import com.fr.plugin.db.redis.ui.pool.RedisConnectionPoolConfigPane;
import com.fr.plugin.db.redis.ui.proxy.RedisConnectionProxyConfigPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class RedisConnectionPane
extends DatabaseConnectionPane<RedisDatabaseConnection> {
    private UITextField hostTextField;
    private UITextField portNumberField;
    private UIPasswordField passwordTextField;

    protected JPanel mainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.hostTextField = new UITextField();
        this.portNumberField = new UITextField();
        this.passwordTextField = new UIPasswordField();
        JPanel jPanel2 = new JPanel();
        GridLayout gridLayout = new GridLayout(1, 2);
        jPanel2.setLayout(gridLayout);
        UIButton uIButton = new UIButton();
        uIButton.setIcon(IOKit.readIcon((String)"/com/fr/plugin/db/redis/images/help.png"));
        uIButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor((Component)((Object)RedisConnectionPane.this)), DesignKit.i18nText((String)"Plugin-Redis_Cluster_Config_Description"), DesignKit.i18nText((String)"Plugin-Redis_Connect_Cluster_Description"), 1);
            }
        });
        Component[][] componentArray = new Component[][]{{new UILabel(DesignKit.i18nText((String)"Plugin-Redis_Host") + ":"), GUICoreKit.createBorderLayoutPane((Object[])new Object[]{this.hostTextField, "Center", uIButton, "East"})}, {new UILabel(DesignKit.i18nText((String)"Plugin-Redis_Port") + ":"), this.portNumberField}, {new UILabel(DesignKit.i18nText((String)"Plugin-Redis_Password") + ":"), this.passwordTextField}, {null, jPanel2}};
        UIActionLabel uIActionLabel = new UIActionLabel(DesignKit.i18nText((String)"Plugin-Redis_Pool_Config"));
        UIActionLabel uIActionLabel2 = new UIActionLabel(DesignKit.i18nText((String)"Plugin-Redis_Proxy_Config"));
        uIActionLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final RedisConnectionPoolConfig redisConnectionPoolConfig = RedisConnectionPoolConfig.getInstance();
                final RedisConnectionPoolConfigPane redisConnectionPoolConfigPane = new RedisConnectionPoolConfigPane();
                redisConnectionPoolConfigPane.populate(redisConnectionPoolConfig);
                BasicDialog basicDialog = redisConnectionPoolConfigPane.showWindow(SwingUtilities.getWindowAncestor((Component)((Object)RedisConnectionPane.this)), (DialogActionListener)new DialogActionAdapter(){

                    public void doOk() {
                        ConfigurationKit.modify(RedisConnectionPoolConfig.class, (Runner)new Runner(){

                            public void run() {
                                redisConnectionPoolConfigPane.update(redisConnectionPoolConfig);
                            }
                        });
                    }
                });
                basicDialog.setVisible(true);
            }
        });
        uIActionLabel2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final RedisConnectionProxyConfig redisConnectionProxyConfig = RedisConnectionProxyConfig.getInstance();
                final RedisConnectionProxyConfigPane redisConnectionProxyConfigPane = new RedisConnectionProxyConfigPane();
                redisConnectionProxyConfigPane.populate(redisConnectionProxyConfig);
                BasicDialog basicDialog = redisConnectionProxyConfigPane.showWindow(SwingUtilities.getWindowAncestor((Component)((Object)RedisConnectionPane.this)), (DialogActionListener)new DialogActionAdapter(){

                    public void doOk() {
                        ConfigurationKit.modify(RedisConnectionProxyConfig.class, (Runner)new Runner(){

                            public void run() {
                                redisConnectionProxyConfigPane.update(redisConnectionProxyConfig);
                            }
                        });
                    }
                });
                basicDialog.setVisible(true);
            }
        });
        jPanel2.add(GUICoreKit.createFlowPane((Component)uIActionLabel, (int)0));
        jPanel2.add(GUICoreKit.createFlowPane((Component)uIActionLabel2, (int)0));
        double d = -2.0;
        double[] dArray = new double[]{d, d, d, d, d};
        double[] dArray2 = new double[]{d, 400.0};
        JPanel jPanel3 = TableLayoutKit.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2);
        jPanel3.setBorder((Border)UITitledBorder.createBorderWithTitle((String)"Redis"));
        JPanel jPanel4 = GUICoreKit.createNormalFlowInnerContainerPane();
        jPanel4.add(jPanel3);
        jPanel.add((Component)jPanel4, "Center");
        return jPanel;
    }

    protected void populateSubDatabaseConnectionBean(RedisDatabaseConnection redisDatabaseConnection) {
        this.hostTextField.setText(redisDatabaseConnection.getHost());
        this.portNumberField.setText(redisDatabaseConnection.getPort());
        this.passwordTextField.setText(redisDatabaseConnection.getPassword());
    }

    protected RedisDatabaseConnection updateSubDatabaseConnectionBean() {
        RedisDatabaseConnection redisDatabaseConnection = new RedisDatabaseConnection();
        redisDatabaseConnection.setHost(this.hostTextField.getText());
        redisDatabaseConnection.setPort(this.portNumberField.getText());
        redisDatabaseConnection.setPassword(this.passwordTextField.getText());
        return redisDatabaseConnection;
    }

    protected String title4PopupWindow() {
        return "Redis";
    }
}

