/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.ui;

import com.fanruan.api.data.ConnectionKit;
import com.fanruan.api.design.DesignKit;
import com.fanruan.api.design.ui.component.UIButton;
import com.fanruan.api.design.ui.component.UIPlaceholderTextField;
import com.fanruan.api.design.ui.container.BasicPane;
import com.fanruan.api.design.util.GUICoreKit;
import com.fanruan.api.design.work.ConnectionComboBoxPanel;
import com.fanruan.api.log.LogKit;
import com.fanruan.api.util.ArrayKit;
import com.fanruan.api.util.StringKit;
import com.fr.data.impl.Connection;
import com.fr.data.operator.DataOperator;
import com.fr.plugin.db.redis.core.RedisDatabaseConnection;
import com.fr.plugin.db.redis.ui.event.DataLoadedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public class RedisDBConnectionChosePane
extends BasicPane {
    private ConnectionComboBoxPanel connectionComboBoxPanel;
    private DefaultListModel listModel = new DefaultListModel();
    private List<DataLoadedListener> listeners = new ArrayList<DataLoadedListener>();
    private UIPlaceholderTextField keysPatternTextField;

    public RedisDBConnectionChosePane() {
        this.setLayout(new BorderLayout(4, 4));
        this.connectionComboBoxPanel = new ConnectionComboBoxPanel(Connection.class){

            protected void filterConnection(Connection connection, String string, List<String> list) {
                connection.addConnection(list, string, new Class[]{RedisDatabaseConnection.class});
            }
        };
        this.add((Component)this.connectionComboBoxPanel, "North");
        this.connectionComboBoxPanel.addComboBoxActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RedisDBConnectionChosePane.this.loadKeys();
            }
        });
        JList jList = new JList(this.listModel);
        this.keysPatternTextField = new UIPlaceholderTextField(10);
        this.keysPatternTextField.setPlaceholder(DesignKit.i18nText((String)"Plugin-Redis_Keys_Pattern"));
        JPanel jPanel = new JPanel(new BorderLayout());
        UIButton uIButton = new UIButton(DesignKit.i18nText((String)"Plugin-Redis_Keys_Pattern_Search"));
        uIButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RedisDBConnectionChosePane.this.loadKeys();
            }
        });
        jPanel.add((Component)GUICoreKit.createBorderLayoutPane((Object[])new Object[]{this.keysPatternTextField, "Center", uIButton, "East"}), "North");
        jPanel.add(jList, "Center");
        this.add(jPanel, "Center");
    }

    private void loadKeys() {
        String string = this.getSelectRedisConnectionName();
        if (StringKit.isEmpty((String)string)) {
            this.clearList();
            this.fireDataLoaded(ArrayKit.EMPTY_STRING_ARRAY);
            return;
        }
        RedisDatabaseConnection redisDatabaseConnection = (RedisDatabaseConnection)ConnectionKit.getConnection((String)string, RedisDatabaseConnection.class);
        if (redisDatabaseConnection != null) {
            this.listMatchedPatternKeys(redisDatabaseConnection);
        }
    }

    private void clearList() {
        this.listModel.clear();
    }

    private void listMatchedPatternKeys(final RedisDatabaseConnection redisDatabaseConnection) {
        this.clearList();
        new SwingWorker<String[], Void>(){

            @Override
            protected String[] doInBackground() throws Exception {
                String string = RedisDBConnectionChosePane.this.keysPatternTextField.getText();
                if (StringKit.isEmpty((String)string)) {
                    return ArrayKit.EMPTY_STRING_ARRAY;
                }
                return DataOperator.getInstance().getTableSummary((Connection)redisDatabaseConnection, new String[]{string});
            }

            @Override
            protected void done() {
                try {
                    String[] stringArray;
                    for (String string : stringArray = (String[])this.get()) {
                        RedisDBConnectionChosePane.this.listModel.addElement(string);
                    }
                    RedisDBConnectionChosePane.this.fireDataLoaded(stringArray);
                }
                catch (Exception exception) {
                    LogKit.error((String)exception.getMessage(), (Throwable)exception);
                }
            }
        }.execute();
    }

    public String getSelectRedisConnectionName() {
        return this.connectionComboBoxPanel.getSelectedItem();
    }

    public void populateConnection(Connection connection) {
        this.connectionComboBoxPanel.populate(connection);
    }

    public void addDataLoadedListener(DataLoadedListener dataLoadedListener) {
        this.listeners.add(dataLoadedListener);
    }

    private void fireDataLoaded(String[] stringArray) {
        for (DataLoadedListener dataLoadedListener : this.listeners) {
            dataLoadedListener.fireEvent(stringArray);
        }
    }

    protected String title4PopupWindow() {
        return "Choose";
    }
}

