/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.ui;

import com.fanruan.api.design.DesignKit;
import com.fanruan.api.design.ui.component.UIActionLabel;
import com.fanruan.api.design.ui.component.UILabel;
import com.fanruan.api.design.ui.component.code.UISyntaxTextArea;
import com.fanruan.api.design.ui.container.BasicPane;
import com.fanruan.api.design.ui.editor.ValueEditorPane;
import com.fanruan.api.design.ui.layout.TableLayoutKit;
import com.fanruan.api.design.util.GUICoreKit;
import com.fanruan.api.log.LogKit;
import com.fanruan.api.net.CloudKit;
import com.fr.design.gui.itextarea.DescriptionTextArea;
import com.fr.plugin.db.redis.core.order.OrderValue;
import com.fr.plugin.db.redis.ui.value.IndexValuePaneFactory;
import com.fr.plugin.db.redis.util.RedisDesignUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;

public class RedisQueryPane
extends BasicPane {
    private UISyntaxTextArea sqlTextPane;
    private ValueEditorPane dbIndexEditor;
    private UISyntaxTextArea scriptTextPane;

    public RedisQueryPane() {
        this.setLayout(new BorderLayout());
        this.sqlTextPane = new UISyntaxTextArea();
        this.scriptTextPane = new UISyntaxTextArea();
        this.dbIndexEditor = IndexValuePaneFactory.createValueEditorPane();
        UIActionLabel uIActionLabel = new UIActionLabel(DesignKit.i18nText((String)"Plugin-Redis_Help"));
        uIActionLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Desktop.getDesktop().browse(URI.create(CloudKit.acquireUrlByKind((String)"help.redis")));
                }
                catch (IOException iOException) {
                    LogKit.error((String)iOException.getMessage(), (Throwable)iOException);
                }
            }
        });
        DescriptionTextArea descriptionTextArea = new DescriptionTextArea();
        descriptionTextArea.setWrapStyleWord(true);
        descriptionTextArea.setLineWrap(true);
        descriptionTextArea.setText(DesignKit.i18nText((String)"Plugin-Redis_Script_Text_Description"));
        Component[][] componentArray = new Component[][]{{new UILabel(DesignKit.i18nText((String)"Plugin-Redis_DB_Index") + ":"), this.dbIndexEditor}, {GUICoreKit.createBorderLayoutPane((Object[])new Object[]{new UILabel(DesignKit.i18nText((String)"Plugin-Redis_Query_Condition") + ":"), "North"}), RedisDesignUtils.createConditionTextPane(this.sqlTextPane, "text/plain", 300)}};
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d, d};
        double[] dArray2 = new double[]{d, d2};
        this.add(TableLayoutKit.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2));
    }

    protected String title4PopupWindow() {
        return "Query";
    }

    public String getQuery() {
        return this.sqlTextPane.getText();
    }

    public void setQuery(String string) {
        this.sqlTextPane.setText(string);
    }

    public OrderValue getOrderValue() {
        return (OrderValue)((Object)this.dbIndexEditor.update());
    }

    public void setOrderValue(OrderValue orderValue) {
        this.dbIndexEditor.populate((Object)orderValue);
    }

    public String getScript() {
        return this.scriptTextPane.getText();
    }

    public void setScript(String string) {
        this.scriptTextPane.setText(string);
    }
}

