/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.ui;

import com.fanruan.api.design.DesignKit;
import com.fanruan.api.design.ui.component.UIButton;
import com.fanruan.api.design.ui.component.UIDictionaryComboBox;
import com.fanruan.api.design.ui.component.UILabel;
import com.fanruan.api.design.ui.component.code.UISyntaxTextArea;
import com.fanruan.api.design.ui.container.BasicPane;
import com.fanruan.api.design.ui.editor.ValueEditorPane;
import com.fanruan.api.design.ui.layout.TableLayoutKit;
import com.fanruan.api.design.util.GUICoreKit;
import com.fanruan.api.log.LogKit;
import com.fanruan.api.util.IOKit;
import com.fr.plugin.db.redis.core.order.OrderValue;
import com.fr.plugin.db.redis.core.script.EngineType;
import com.fr.plugin.db.redis.ui.value.IndexValuePaneFactory;
import com.fr.plugin.db.redis.util.RedisDesignUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;

public class RedisScriptPane
extends BasicPane {
    private ValueEditorPane dbIndexEditor;
    private UIDictionaryComboBox<EngineType> engineTypeComboBox;
    private UISyntaxTextArea scriptTextPane;

    public RedisScriptPane() {
        this.setLayout(new BorderLayout());
        this.scriptTextPane = new UISyntaxTextArea();
        this.dbIndexEditor = IndexValuePaneFactory.createValueEditorPane();
        this.engineTypeComboBox = new UIDictionaryComboBox((Object[])new EngineType[]{EngineType.V8, EngineType.JAVA}, new String[]{DesignKit.i18nText((String)"Plugin-Redis_Script_Engine_Type_V8"), DesignKit.i18nText((String)"Plugin-Redis_Script_Engine_Type_Default")});
        UIButton uIButton = new UIButton();
        uIButton.setIcon(IOKit.readIcon((String)"/com/fr/plugin/db/redis/images/help.png"));
        uIButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Desktop.getDesktop().browse(URI.create("https://help.finereport.com/doc-view-1957.html"));
                }
                catch (IOException iOException) {
                    LogKit.error((String)iOException.getMessage(), (Throwable)iOException);
                }
            }
        });
        Component[][] componentArray = new Component[][]{{new UILabel(DesignKit.i18nText((String)"Plugin-Redis_DB_Index") + ":"), this.dbIndexEditor}, {new UILabel(DesignKit.i18nText((String)"Plugin-Redis_Script_Engine_Type") + ":"), GUICoreKit.createBorderLayoutPane((Object[])new Object[]{this.engineTypeComboBox, "Center", uIButton, "East"})}, {new UILabel(DesignKit.i18nText((String)"Plugin-Redis_Script_Query_Text") + ":"), RedisDesignUtils.createConditionTextPane(this.scriptTextPane, "text/javascript", 300)}};
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d, d, d, d};
        double[] dArray2 = new double[]{d, d2};
        this.add(TableLayoutKit.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2));
    }

    protected String title4PopupWindow() {
        return "Script";
    }

    public OrderValue getOrderValue() {
        return (OrderValue)((Object)this.dbIndexEditor.update());
    }

    public void setOrderValue(OrderValue orderValue) {
        this.dbIndexEditor.populate((Object)orderValue);
    }

    public EngineType getEngineType() {
        return (EngineType)((Object)this.engineTypeComboBox.getSelectedItem());
    }

    public void setEngineType(EngineType engineType) {
        this.engineTypeComboBox.setSelectedItem((Object)engineType);
    }

    public String getScript() {
        return this.scriptTextPane.getText();
    }

    public void setScript(String string) {
        this.scriptTextPane.setText(string);
    }
}

