/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.ui;

import com.fanruan.api.data.ConnectionKit;
import com.fanruan.api.design.DesignKit;
import com.fanruan.api.util.StringKit;
import com.fr.plugin.db.redis.core.RedisTableData;
import com.fr.plugin.db.redis.core.order.OrderValue;
import com.fr.plugin.db.redis.ui.RedisBaseTableDataPane;
import com.fr.plugin.db.redis.ui.RedisQueryPane;
import com.fr.script.Calculator;
import com.fr.stable.ParameterProvider;
import java.util.List;
import javax.swing.JComponent;

public class RedisTableDataPane
extends RedisBaseTableDataPane<RedisTableData> {
    private RedisQueryPane queryPane;

    @Override
    protected String title4PopupWindow() {
        return DesignKit.i18nText((String)"Plugin-Redis_Query");
    }

    @Override
    protected JComponent createQueryPane() {
        if (this.queryPane == null) {
            this.queryPane = new RedisQueryPane();
        }
        return this.queryPane;
    }

    @Override
    public String[] paramTexts() {
        return new String[]{this.queryPane.getQuery(), this.queryPane.getScript()};
    }

    @Override
    public OrderValue getOrderValue() {
        return this.queryPane.getOrderValue();
    }

    public void populateBean(RedisTableData redisTableData) {
        if (redisTableData == null) {
            return;
        }
        Calculator calculator = Calculator.createCalculator();
        this.editorPane.populate((Object[])redisTableData.getParameters(calculator));
        this.chosePane.populateConnection(redisTableData.getDatabase());
        this.queryPane.setQuery(redisTableData.getQuery());
        this.queryPane.setScript(redisTableData.getScript());
        this.queryPane.setOrderValue(redisTableData.getOrderValue());
    }

    public RedisTableData updateBean() {
        RedisTableData redisTableData = new RedisTableData();
        String string = this.chosePane.getSelectRedisConnectionName();
        if (StringKit.isNotEmpty((String)string)) {
            redisTableData.setDatabase(ConnectionKit.createNameConnection((String)string));
        }
        List list = this.editorPane.update();
        ParameterProvider[] parameterProviderArray = list.toArray(new ParameterProvider[list.size()]);
        redisTableData.setParameters(parameterProviderArray);
        redisTableData.setQuery(this.queryPane.getQuery());
        redisTableData.setScript(this.queryPane.getScript());
        redisTableData.setOrderValue(this.queryPane.getOrderValue());
        return redisTableData;
    }
}

