/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.ui.pool;

import com.fanruan.api.design.DesignKit;
import com.fanruan.api.design.ui.component.UICheckBox;
import com.fanruan.api.design.ui.component.UIIntNumberField;
import com.fanruan.api.design.ui.component.UILabel;
import com.fanruan.api.design.ui.component.UINumberField;
import com.fanruan.api.design.ui.container.BasicPane;
import com.fanruan.api.design.ui.layout.TableLayoutKit;
import com.fr.plugin.db.redis.core.pool.RedisConnectionPoolConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;

public class RedisConnectionPoolConfigPane
extends BasicPane {
    private UIIntNumberField maxTotalNumberFiled;
    private UINumberField maxWaitNumberField;
    private UIIntNumberField maxIdleNumberField;
    private UICheckBox blockWhenExhaustedCheckBox;
    private UICheckBox lifoCheckBox;
    private UIIntNumberField timeoutNumberField;

    public RedisConnectionPoolConfigPane() {
        this.setLayout(new BorderLayout());
        this.maxTotalNumberFiled = new UIIntNumberField();
        this.maxWaitNumberField = new UINumberField();
        this.maxWaitNumberField.setMinValue(-1.0);
        this.maxWaitNumberField.setMaxDecimalLength(0);
        this.maxIdleNumberField = new UIIntNumberField();
        this.blockWhenExhaustedCheckBox = new UICheckBox();
        this.blockWhenExhaustedCheckBox.setSelected(false);
        this.lifoCheckBox = new UICheckBox();
        this.timeoutNumberField = new UIIntNumberField();
        Component[][] componentArray = new JComponent[][]{{new UILabel(DesignKit.i18nText((String)"Plugin-Redis_Pool_Max_Total") + ":"), this.maxTotalNumberFiled}, {new UILabel(DesignKit.i18nText((String)"Plugin-Redis_Pool_Max_Wait") + ":"), this.maxWaitNumberField}, {new UILabel(DesignKit.i18nText((String)"Plugin-Redis_Pool_Max_Idle") + ":"), this.maxIdleNumberField}, {new UILabel(DesignKit.i18nText((String)"Plugin-Redis_Pool_Block_When_Exhausted") + ":"), this.blockWhenExhaustedCheckBox}, {new UILabel(DesignKit.i18nText((String)"Plugin-Redis_Pool_Lifo") + ":"), this.lifoCheckBox}, {new UILabel(DesignKit.i18nText((String)"Plugin-Redis_Pool_Timeout") + ":"), this.timeoutNumberField}};
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d, d, d, d, d, d};
        double[] dArray2 = new double[]{d, d2};
        this.add(TableLayoutKit.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2), "Center");
    }

    protected String title4PopupWindow() {
        return DesignKit.i18nText((String)"Plugin-Redis_Pool_Config");
    }

    public void populate(RedisConnectionPoolConfig redisConnectionPoolConfig) {
        this.maxTotalNumberFiled.setValue((double)redisConnectionPoolConfig.getMaxTotal());
        this.maxWaitNumberField.setValue((double)redisConnectionPoolConfig.getMaxWait());
        this.maxIdleNumberField.setValue((double)redisConnectionPoolConfig.getMaxIdle());
        this.blockWhenExhaustedCheckBox.setSelected(redisConnectionPoolConfig.getBlockWhenExhausted());
        this.lifoCheckBox.setSelected(redisConnectionPoolConfig.getLifo());
        this.timeoutNumberField.setValue((double)redisConnectionPoolConfig.getTimeout());
    }

    public void update(RedisConnectionPoolConfig redisConnectionPoolConfig) {
        redisConnectionPoolConfig.setMaxTotal((int)this.maxTotalNumberFiled.getValue());
        redisConnectionPoolConfig.setMaxWait((int)this.maxWaitNumberField.getValue());
        redisConnectionPoolConfig.setMaxIdle((int)this.maxIdleNumberField.getValue());
        redisConnectionPoolConfig.setBlockWhenExhausted(this.blockWhenExhaustedCheckBox.isSelected());
        redisConnectionPoolConfig.setLifo(this.lifoCheckBox.isSelected());
        redisConnectionPoolConfig.setTimeout((int)this.timeoutNumberField.getValue());
    }
}

