/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.ui.proxy;

import com.fanruan.api.design.DesignKit;
import com.fanruan.api.design.ui.component.UIButton;
import com.fanruan.api.design.ui.component.UICheckBox;
import com.fanruan.api.design.ui.component.UIIntNumberField;
import com.fanruan.api.design.ui.component.UILabel;
import com.fanruan.api.design.ui.component.UIPasswordField;
import com.fanruan.api.design.ui.component.UITextField;
import com.fanruan.api.design.ui.container.BasicPane;
import com.fanruan.api.design.ui.layout.TableLayoutKit;
import com.fanruan.api.design.util.GUICoreKit;
import com.fr.plugin.db.redis.core.pool.RedisConnectionProxyConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;

public class RedisConnectionProxyConfigPane
extends BasicPane {
    private UICheckBox openCheckBox;
    private UITextField hostTextField;
    private UIIntNumberField portNumberField;
    private UITextField usernameTextField;
    private UIPasswordField passwordTextField;
    private UITextField privateKeyPathTextField;

    public RedisConnectionProxyConfigPane() {
        this.setLayout(new BorderLayout());
        this.openCheckBox = new UICheckBox();
        this.openCheckBox.setSelected(false);
        this.hostTextField = new UITextField();
        this.portNumberField = new UIIntNumberField();
        this.usernameTextField = new UITextField();
        this.passwordTextField = new UIPasswordField();
        this.privateKeyPathTextField = new UITextField();
        this.privateKeyPathTextField.setPlaceholder(DesignKit.i18nText((String)"Plugin-Redis_Proxy_Private_Key_Tip"));
        UIButton uIButton = new UIButton("...");
        UILabel uILabel = new UILabel(DesignKit.i18nText((String)"Plugin-Redis_Proxy_Description"), 0);
        Component[][] componentArray = new JComponent[][]{{new UILabel(DesignKit.i18nText((String)"Plugin-Redis_Proxy_Open") + ":"), GUICoreKit.createBorderLayoutPane((Object[])new Object[]{this.openCheckBox, "West", uILabel, "Center"})}, {new UILabel(DesignKit.i18nText((String)"Plugin-Redis_Proxy_Host") + ":"), this.hostTextField}, {new UILabel(DesignKit.i18nText((String)"Plugin-Redis_Proxy_Port") + ":"), this.portNumberField}, {new UILabel(DesignKit.i18nText((String)"Plugin-Redis_Proxy_Username") + ":"), this.usernameTextField}, {new UILabel(DesignKit.i18nText((String)"Plugin-Redis_Proxy_Password") + ":"), this.passwordTextField}, {new UILabel(DesignKit.i18nText((String)"Plugin-Redis_Proxy_Private_Key_Path") + ":"), GUICoreKit.createBorderLayoutPane((Object[])new Object[]{this.privateKeyPathTextField, "Center", uIButton, "East"})}};
        uIButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.showOpenDialog(SwingUtilities.getWindowAncestor((Component)((Object)RedisConnectionProxyConfigPane.this)));
                File file = jFileChooser.getSelectedFile();
                if (file != null) {
                    RedisConnectionProxyConfigPane.this.privateKeyPathTextField.setText(file.getAbsolutePath());
                }
            }
        });
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d, d, d, d, d, d};
        double[] dArray2 = new double[]{d, d2};
        this.add(TableLayoutKit.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2), "Center");
    }

    protected String title4PopupWindow() {
        return DesignKit.i18nText((String)"Plugin-Redis_Proxy_Config");
    }

    public void populate(RedisConnectionProxyConfig redisConnectionProxyConfig) {
        this.openCheckBox.setSelected(redisConnectionProxyConfig.isOpen());
        this.hostTextField.setText(redisConnectionProxyConfig.getHost());
        this.portNumberField.setValue((double)redisConnectionProxyConfig.getPort());
        this.usernameTextField.setText(redisConnectionProxyConfig.getUsername());
        this.passwordTextField.setText(redisConnectionProxyConfig.getPassword());
        this.privateKeyPathTextField.setText(redisConnectionProxyConfig.getPrivateKeyPath());
    }

    public void update(RedisConnectionProxyConfig redisConnectionProxyConfig) {
        redisConnectionProxyConfig.setOpen(this.openCheckBox.isSelected());
        redisConnectionProxyConfig.setHost(this.hostTextField.getText());
        redisConnectionProxyConfig.setPort((int)this.portNumberField.getValue());
        redisConnectionProxyConfig.setUsername(this.usernameTextField.getText());
        redisConnectionProxyConfig.setPassword(this.passwordTextField.getText());
        redisConnectionProxyConfig.setPrivateKeyPath(this.privateKeyPathTextField.getText());
    }
}

