/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.ui.value;

import com.fanruan.api.design.DesignKit;
import com.fanruan.api.design.ui.component.UITextField;
import com.fanruan.api.design.util.GUICoreKit;
import com.fanruan.api.design.work.formula.FormulaUIKit;
import com.fr.base.BaseFormula;
import com.fr.design.dialog.DialogActionAdapter;
import com.fr.design.dialog.DialogActionListener;
import com.fr.design.editor.editor.Editor;
import com.fr.design.formula.UIFormula;
import com.fr.plugin.db.redis.core.order.impl.FormulaOrderValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class FormulaEditor
extends Editor<FormulaOrderValue> {
    private UITextField currentTextField;
    private ShowPaneListener listener = new ShowPaneListener();
    private FormulaOrderValue orderValue = new FormulaOrderValue(BaseFormula.createFormulaBuilder().build());

    public FormulaEditor() {
        this(DesignKit.i18nText((String)"Plugin-Redis_Formula"));
    }

    public FormulaEditor(String string) {
        this(string, null);
    }

    public FormulaEditor(String string, FormulaOrderValue formulaOrderValue) {
        if (formulaOrderValue != null) {
            this.orderValue = formulaOrderValue;
        }
        this.setLayout(new BorderLayout());
        JPanel jPanel = GUICoreKit.createBorderLayoutPane();
        this.currentTextField = new UITextField(28);
        this.currentTextField.setText(this.orderValue.getValue().getContent());
        jPanel.add((Component)this.currentTextField, "Center");
        this.currentTextField.setEditable(false);
        this.currentTextField.addMouseListener((MouseListener)this.listener);
        this.add(jPanel, "Center");
        this.setName(string);
    }

    public void setColumns(int n) {
        this.currentTextField.setColumns(n);
    }

    public void selected() {
        this.showFormulaPane();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.currentTextField.setEnabled(bl);
    }

    protected void showFormulaPane() {
        final UIFormula uIFormula = FormulaUIKit.createFormulaPaneWhenReserveFormula();
        uIFormula.populate(this.orderValue.getValue());
        uIFormula.showLargeWindow(SwingUtilities.getWindowAncestor((Component)((Object)this)), (DialogActionListener)new DialogActionAdapter(){

            public void doOk() {
                FormulaEditor.this.orderValue.setValue(uIFormula.update());
                FormulaEditor.this.setValue(FormulaEditor.this.orderValue);
                FormulaEditor.this.fireStateChanged();
            }
        }).setVisible(true);
    }

    public FormulaOrderValue getValue() {
        return this.orderValue;
    }

    public void setValue(FormulaOrderValue formulaOrderValue) {
        if (formulaOrderValue == null) {
            formulaOrderValue = new FormulaOrderValue(BaseFormula.createFormulaBuilder().build());
        }
        this.orderValue = formulaOrderValue;
        this.currentTextField.setText(formulaOrderValue.toString());
    }

    public String getIconName() {
        return "type_formula";
    }

    public boolean accept(Object object) {
        return object instanceof FormulaOrderValue;
    }

    public void reset() {
        this.currentTextField.setText("=");
        this.orderValue = new FormulaOrderValue(BaseFormula.createFormulaBuilder().build());
    }

    public void clearData() {
        this.reset();
    }

    private class ShowPaneListener
    extends MouseAdapter {
        private ShowPaneListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (FormulaEditor.this.currentTextField.isEnabled()) {
                FormulaEditor.this.showFormulaPane();
            }
        }
    }
}

