/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.db.redis.ui.value;

import com.fanruan.api.design.ui.component.UIIntNumberField;
import com.fanruan.api.util.GeneralKit;
import com.fr.design.editor.editor.Editor;
import com.fr.plugin.db.redis.core.order.impl.NumberOrderValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class IntegerEditor
extends Editor<NumberOrderValue> {
    private static final long serialVersionUID = 1L;
    protected UIIntNumberField numberField;
    protected String oldValue = "";
    KeyListener textKeyListener = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 27) {
                IntegerEditor.this.numberField.setText(IntegerEditor.this.oldValue);
            }
            if (n == 10) {
                IntegerEditor.this.fireEditingStopped();
            } else {
                IntegerEditor.this.fireStateChanged();
            }
        }
    };

    public IntegerEditor() {
        this(null, "\u5e8f\u53f7");
    }

    public IntegerEditor(NumberOrderValue numberOrderValue, String string) {
        this.setLayout(new BorderLayout());
        this.numberField = new UIIntNumberField();
        this.add((Component)this.numberField, "Center");
        this.numberField.addKeyListener(this.textKeyListener);
        this.numberField.setHorizontalAlignment(4);
        this.setValue(numberOrderValue);
        this.setName(string);
    }

    public void setColumns(int n) {
        this.numberField.setColumns(n);
    }

    public int getHorizontalAlignment() {
        return this.numberField.getHorizontalAlignment();
    }

    public void setHorizontalAlignment(int n) {
        this.numberField.setHorizontalAlignment(n);
    }

    public void setEnabled(boolean bl) {
        this.numberField.setEnabled(bl);
    }

    public void selected() {
        this.requestFocus();
    }

    public String getIconName() {
        return "type_double";
    }

    public void requestFocus() {
        this.numberField.requestFocus();
    }

    public NumberOrderValue getValue() {
        return new NumberOrderValue((int)this.numberField.getValue());
    }

    public void setValue(NumberOrderValue numberOrderValue) {
        if (numberOrderValue == null) {
            numberOrderValue = new NumberOrderValue(0);
        }
        this.numberField.setValue((double)numberOrderValue.getValue().intValue());
        this.oldValue = GeneralKit.objectToString((Object)((Object)numberOrderValue));
    }

    public boolean accept(Object object) {
        return object != null && object instanceof NumberOrderValue;
    }
}

