/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.util;

import com.fr.stable.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class NumberUtils {
    private static final int DEF_DIV_SCALE = 10;

    private NumberUtils() {
    }

    public static double add(double d, double d2) {
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d));
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(d2));
        return bigDecimal.add(bigDecimal2).doubleValue();
    }

    public static double add(double ... dArray) {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        for (double d : dArray) {
            bigDecimal = bigDecimal.add(new BigDecimal(Double.toString(d)));
        }
        return bigDecimal.doubleValue();
    }

    public static double sub(double d, double d2) {
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d));
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(d2));
        return bigDecimal.subtract(bigDecimal2).doubleValue();
    }

    public static double mul(double d, double d2) {
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d));
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(d2));
        return bigDecimal.multiply(bigDecimal2).doubleValue();
    }

    public static double div(double d, double d2) {
        return NumberUtils.div(d, d2, 10);
    }

    public static double div(double d, double d2, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d));
        BigDecimal bigDecimal2 = new BigDecimal(Double.toString(d2));
        return bigDecimal.divide(bigDecimal2, n, 4).doubleValue();
    }

    public static double round(double d, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal bigDecimal = new BigDecimal(Double.toString(d));
        BigDecimal bigDecimal2 = new BigDecimal("1");
        return bigDecimal.divide(bigDecimal2, n, 4).doubleValue();
    }

    public static String formatNumber(Double d, String string) {
        if (d != null) {
            DecimalFormat decimalFormat = new DecimalFormat();
            if (StringUtils.isNotBlank((String)string)) {
                decimalFormat.applyPattern(string);
            } else {
                decimalFormat.applyPattern("#,##0.00");
            }
            return decimalFormat.format(d);
        }
        return null;
    }

    public static String formatNumber(Double d) {
        return NumberUtils.formatNumber(d, "#,##0.00");
    }

    public static String formatNumberWithOutZero(Double d) {
        if (d == null || d == 0.0) {
            return "";
        }
        return NumberUtils.formatNumber(d, "#,##0");
    }

    public static String formatNumberWithOutZero1(Double d) {
        if (d == null || d == 0.0) {
            return "";
        }
        return NumberUtils.formatNumber(d, "#,##0.00");
    }

    public static Double abs(Double d) {
        return Math.abs(d);
    }

    public static String percent(Double d, Double d2) {
        if (d == null || d <= 0.0 || d2 == null || d2 <= 0.0) {
            return "0.00";
        }
        return NumberUtils.formatNumber(NumberUtils.mul(NumberUtils.div(d, d2), 100.0), "0.00");
    }
}

